/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.plugins.forge.PlayerPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;

public class ItemTicket
extends ItemRailcraft {
    public static final IStackFilter FILTER = new IStackFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return stack != null && stack.getItem() instanceof ItemTicket;
        }
    };
    public static final int LINE_LENGTH = 32;
    public static ItemTicket item;

    public static void registerItem() {
        String tag;
        if (item == null && RailcraftConfig.isItemEnabled(tag = "railcraft.routing.ticket")) {
            item = new ItemTicket();
            item.setUnlocalizedName(tag);
            RailcraftRegistry.register(item);
        }
    }

    public static ItemStack getTicket() {
        if (item == null) {
            return null;
        }
        return new ItemStack((Item)item);
    }

    public static boolean isNBTValid(NBTTagCompound nbt) {
        if (nbt == null) {
            return false;
        }
        if (!nbt.hasKey("dest")) {
            return false;
        }
        NBTTagString dest = (NBTTagString)nbt.getTag("dest");
        if (dest.func_150285_a_() == null) {
            return false;
        }
        return dest.func_150285_a_().length() <= 32;
    }

    public static ItemStack copyTicket(ItemStack source) {
        if (item == null) {
            return null;
        }
        if (source == null) {
            return null;
        }
        if (source.getItem() instanceof ItemTicket) {
            ItemStack ticket = ItemTicket.getTicket();
            NBTTagCompound nbt = source.getTagCompound();
            if (nbt != null) {
                ticket.setTagCompound((NBTTagCompound)nbt.copy());
            }
            return ticket;
        }
        return null;
    }

    public static boolean setTicketData(ItemStack ticket, String dest, String title, GameProfile owner) {
        if (ticket == null || !(ticket.getItem() instanceof ItemTicket)) {
            return false;
        }
        if (dest.length() > 32) {
            return false;
        }
        if (owner == null || owner.equals((Object)"")) {
            return false;
        }
        NBTTagCompound data = InvTools.getItemData(ticket);
        data.setString("dest", dest);
        data.setString("title", title);
        PlayerPlugin.writeOwnerToNBT(data, owner);
        return true;
    }

    public static String getDestination(ItemStack ticket) {
        if (ticket == null || !(ticket.getItem() instanceof ItemTicket)) {
            return "";
        }
        NBTTagCompound nbt = ticket.getTagCompound();
        if (nbt == null) {
            return "";
        }
        return nbt.getString("dest");
    }

    public static boolean matchesOwnerOrOp(ItemStack ticket, GameProfile player) {
        if (!(item instanceof ItemTicket)) {
            return false;
        }
        return PlayerPlugin.isOwnerOrOp(ItemTicket.getOwner(ticket), player);
    }

    public static GameProfile getOwner(ItemStack ticket) {
        if (ticket == null || !(ticket.getItem() instanceof ItemTicket)) {
            return new GameProfile(null, "[Unknown]");
        }
        NBTTagCompound nbt = ticket.getTagCompound();
        if (nbt == null) {
            return new GameProfile(null, "[Unknown]");
        }
        return PlayerPlugin.readOwnerFromNBT(nbt);
    }

    public boolean validateNBT(NBTTagCompound nbt) {
        String dest = nbt.getString("dest");
        return dest.length() < 32;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("railcraft:ticket");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (stack.hasTagCompound()) {
            String dest;
            GameProfile owner = ItemTicket.getOwner(stack);
            if (owner.getId() != null) {
                list.add(EnumChatFormatting.WHITE + LocalizationPlugin.translate("railcraft.gui.routing.ticket.tip.issuer"));
                list.add(EnumChatFormatting.GRAY + PlayerPlugin.getUsername(player.worldObj, owner));
            }
            if (!(dest = ItemTicket.getDestination(stack)).equals("")) {
                list.add(EnumChatFormatting.WHITE + LocalizationPlugin.translate("railcraft.gui.routing.ticket.tip.dest"));
                list.add(EnumChatFormatting.GRAY + dest);
            }
        } else {
            list.add(LocalizationPlugin.translate("railcraft.gui.routing.ticket.tip.blank"));
        }
    }
}

