/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.PlayerPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IEditableItem;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemTicketGold
extends ItemTicket
implements IEditableItem {
    public static final IStackFilter FILTER = new IStackFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            return stack != null && stack.getItem() instanceof ItemTicketGold;
        }
    };
    public static ItemTicketGold item;

    public static void registerItem() {
        String tag;
        if (item == null && RailcraftConfig.isItemEnabled(tag = "railcraft.routing.ticket.gold")) {
            item = new ItemTicketGold();
            item.setUnlocalizedName(tag);
            item.setRarity(1);
            RailcraftRegistry.register(item);
            CraftingPlugin.addShapelessRecipe(new ItemStack((Item)item), Items.paper, "nuggetGold");
        }
    }

    public static ItemStack getTicket() {
        if (item == null) {
            return null;
        }
        return new ItemStack((Item)item);
    }

    public boolean doesContainerItemLeaveCraftingGrid(ItemStack stack) {
        return false;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        stack = stack.copy();
        stack.stackSize = 1;
        return stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("railcraft:ticket.gold");
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (Game.isHost(world) && this.canPlayerEdit(player, stack)) {
            PacketBuilder.instance().sendGoldenTicketGuiPacket((EntityPlayerMP)player);
        }
        return stack;
    }

    @Override
    public boolean canPlayerEdit(EntityPlayer player, ItemStack stack) {
        boolean canEdit = PlayerPlugin.isPlayerOp(player.getGameProfile());
        if (!canEdit && !RailcraftConfig.isRoutingOpsOnly()) {
            GameProfile owner = ItemTicketGold.getOwner(stack);
            canEdit |= owner.getId() == null || owner.equals((Object)player.getCommandSenderName());
        }
        return canEdit;
    }
}

