/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items.firestone;

import cpw.mods.fml.common.registry.EntityRegistry;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.items.EntityItemFireproof;
import mods.railcraft.common.items.firestone.BlockFirestoneRecharge;
import mods.railcraft.common.items.firestone.ItemFirestoneCracked;
import mods.railcraft.common.items.firestone.TileFirestoneRecharge;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityItemFirestone
extends EntityItemFireproof {
    public static void register() {
        EntityRegistry.registerModEntity(EntityItemFirestone.class, (String)"ItemFirestone", (int)75, (Object)Railcraft.getMod(), (int)64, (int)20, (boolean)true);
    }

    public EntityItemFirestone(World world) {
        super(world);
    }

    public EntityItemFirestone(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityItemFirestone(World world, double x, double y, double z, ItemStack stack) {
        super(world, x, y, z, stack);
    }

    @Override
    protected void setOnFireFromLava() {
        int zHit;
        int yHit;
        if (this.isDead) {
            return;
        }
        if (this.worldObj.isRemote) {
            return;
        }
        int xHit = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.getBlock(xHit, yHit = MathHelper.floor_double((double)this.posY), zHit = MathHelper.floor_double((double)this.posZ)).getMaterial() == Material.lava || this.worldObj.getBlock(xHit, yHit + 1, zHit).getMaterial() == Material.lava) {
            for (int y = yHit + 1; y <= yHit + 10; ++y) {
                if (!this.worldObj.isAirBlock(xHit, y, zHit) || this.worldObj.getBlock(xHit, y - 1, zHit).getMaterial() != Material.lava) continue;
                int meta = this.getEntityItem().getItem() instanceof ItemFirestoneCracked ? 1 : 0;
                this.worldObj.setBlock(xHit, y, zHit, BlockFirestoneRecharge.getBlock(), meta, 3);
                TileEntity tile = this.worldObj.getTileEntity(xHit, y, zHit);
                if (!(tile instanceof TileFirestoneRecharge)) continue;
                TileFirestoneRecharge fireTile = (TileFirestoneRecharge)tile;
                ItemStack firestone = this.getEntityItem();
                fireTile.charge = firestone.getMaxDamage() - firestone.getItemDamage();
                if (firestone.hasDisplayName()) {
                    fireTile.setItemName(firestone.getDisplayName());
                }
                this.setDead();
                return;
            }
        }
    }
}

