/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items.firestone;

import java.util.List;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.items.firestone.ItemFirestoneRaw;
import mods.railcraft.common.items.firestone.ItemFirestoneRefined;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemFirestoneCracked
extends ItemFirestoneRefined {
    public static int HEAT = 100;
    public static Item item;

    public static void registerItem() {
        String tag;
        if (item == null && RailcraftConfig.isItemEnabled(tag = "railcraft.firestone.cracked")) {
            item = new ItemFirestoneCracked().setUnlocalizedName(tag);
            RailcraftRegistry.register(item);
        }
    }

    public static ItemStack getItemCharged() {
        return new ItemStack(item);
    }

    public static ItemStack getItemEmpty() {
        return new ItemStack(item, 1, item.getMaxDamage() - 1);
    }

    @Override
    public ItemStack getContainerItem(ItemStack stack) {
        double damageLevel = (double)stack.getItemDamage() / (double)stack.getMaxDamage();
        if (MiscTools.RANDOM.nextDouble() < damageLevel * 1.0E-4) {
            return ItemFirestoneRaw.getItem();
        }
        ItemStack newStack = stack.copy();
        newStack.stackSize = 1;
        newStack = InvTools.damageItem(newStack, 1);
        return newStack;
    }

    @Override
    public int getHeatValue(ItemStack stack) {
        if (stack.getItemDamage() < this.getMaxDamage()) {
            return HEAT;
        }
        return 0;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        ToolTip tip;
        String tipTag = this.getUnlocalizedName() + ".tip.charged";
        if (stack.getItemDamage() >= stack.getMaxDamage() - 5) {
            tipTag = this.getUnlocalizedName() + ".tip.empty";
        }
        if ((tip = ToolTip.buildToolTip(tipTag, new String[0])) != null) {
            info.addAll(tip.convertToStrings());
        }
    }
}

