/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items.firestone;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.items.firestone.ItemFirestoneRefined;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class TileFirestoneRecharge
extends RailcraftTileEntity {
    public static final int[] REBUILD_DELAY = new int[8];
    private final Deque<WorldCoordinate> queue = new LinkedList<WorldCoordinate>();
    private final Set<WorldCoordinate> visitedBlocks = new HashSet<WorldCoordinate>();
    public int charge = 0;
    public long rotationYaw;
    public long preRotationYaw;
    public float yOffset = -2.0f;
    public float preYOffset = -2.0f;
    private Deque<WorldCoordinate> lavaFound = new LinkedList<WorldCoordinate>();
    private int rebuildDelay;
    private String itemName;

    @Override
    public void updateEntity() {
        WorldCoordinate index;
        super.updateEntity();
        if (Game.isNotHost(this.worldObj)) {
            this.preRotationYaw = this.rotationYaw;
            this.rotationYaw += 5L;
            if (this.rotationYaw >= 360L) {
                this.preRotationYaw = this.rotationYaw = 0L;
            }
            this.preYOffset = this.yOffset;
            if (this.yOffset < 0.0f) {
                this.yOffset += 0.0625f;
            }
            return;
        }
        if (this.charge >= ItemFirestoneRefined.item.getMaxDamage()) {
            return;
        }
        if (this.clock % REBUILD_DELAY[this.rebuildDelay] == 0) {
            ++this.rebuildDelay;
            if (this.rebuildDelay >= REBUILD_DELAY.length) {
                this.rebuildDelay = REBUILD_DELAY.length - 1;
            }
            this.rebuildQueue();
        }
        if ((index = this.getNextLavaBlock(true)) != null && this.coolLava(index.x, index.y, index.z)) {
            ++this.charge;
            this.rebuildDelay = 0;
        }
    }

    private boolean coolLava(int x, int y, int z) {
        boolean placed;
        Block block = WorldPlugin.getBlock((IBlockAccess)this.worldObj, x, y, z);
        if (Fluids.LAVA.is(FluidHelper.getFluid(block)) && (placed = WorldPlugin.setBlock(this.worldObj, x, y, z, Blocks.obsidian))) {
            EffectManager.instance.fireSparkEffect(this.worldObj, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, (double)this.xCoord + 0.5, (double)this.yCoord + 0.8, (double)this.zCoord + 0.5);
            this.queueAdjacent(x, y, z);
            this.expandQueue();
            return true;
        }
        return false;
    }

    private WorldCoordinate getNextLavaBlock(boolean remove) {
        if (this.queue.isEmpty()) {
            return null;
        }
        if (remove) {
            WorldCoordinate index = this.queue.pollFirst();
            return index;
        }
        return this.queue.peekFirst();
    }

    void rebuildQueue() {
        this.queue.clear();
        this.visitedBlocks.clear();
        this.lavaFound.clear();
        this.queueAdjacent(this.xCoord, this.yCoord, this.zCoord);
        this.expandQueue();
    }

    private void expandQueue() {
        while (!this.lavaFound.isEmpty()) {
            Deque<WorldCoordinate> blocksToExpand = this.lavaFound;
            this.lavaFound = new LinkedList<WorldCoordinate>();
            for (WorldCoordinate index : blocksToExpand) {
                this.queueAdjacent(index.x, index.y, index.z);
            }
        }
    }

    public void queueAdjacent(int x, int y, int z) {
        this.queueForFilling(x + 1, y, z);
        this.queueForFilling(x - 1, y, z);
        this.queueForFilling(x, y, z + 1);
        this.queueForFilling(x, y, z - 1);
        this.queueForFilling(x, y + 1, z);
        this.queueForFilling(x, y - 1, z);
    }

    public void queueForFilling(int x, int y, int z) {
        WorldCoordinate index = new WorldCoordinate(0, x, y, z);
        if (this.visitedBlocks.add(index)) {
            if ((x - this.xCoord) * (x - this.xCoord) + (z - this.zCoord) * (z - this.zCoord) > 4096) {
                return;
            }
            Block block = WorldPlugin.getBlock((IBlockAccess)this.worldObj, x, y, z);
            if (block == Blocks.obsidian || Fluids.LAVA.is(FluidHelper.getFluid(block))) {
                this.lavaFound.add(index);
                if (FluidHelper.isFullFluidBlock(block, this.worldObj, x, y, z)) {
                    this.queue.addLast(index);
                }
            }
        }
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setShort("charge", (short)this.charge);
        data.setByte("rebuildDelay", (byte)this.rebuildDelay);
        if (this.itemName != null) {
            data.setString("itemName", this.itemName);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.charge = data.getShort("charge");
        this.rebuildDelay = data.getByte("rebuildDelay");
        if (data.hasKey(this.itemName)) {
            this.itemName = data.getString("itemName");
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
    }

    @Override
    public String getLocalizationTag() {
        return "tile.railcraft.firestone.recharge.name";
    }

    @Override
    public short getId() {
        return 222;
    }

    static {
        TileFirestoneRecharge.REBUILD_DELAY[0] = 128;
        TileFirestoneRecharge.REBUILD_DELAY[1] = 256;
        TileFirestoneRecharge.REBUILD_DELAY[2] = 512;
        TileFirestoneRecharge.REBUILD_DELAY[3] = 1024;
        TileFirestoneRecharge.REBUILD_DELAY[4] = 2048;
        TileFirestoneRecharge.REBUILD_DELAY[5] = 4096;
        TileFirestoneRecharge.REBUILD_DELAY[6] = 8192;
        TileFirestoneRecharge.REBUILD_DELAY[7] = 16384;
    }
}

