/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items.waterstone;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.firestone.EntityItemFirestone;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemWaterstoneRefined
extends ItemRailcraft {
    public static int HEAT = 500;
    public static Item item;

    public static void registerItem() {
        String tag;
        if (item == null && RailcraftConfig.isItemEnabled(tag = "railcraft.waterstone.refined")) {
            item = new ItemWaterstoneRefined().setUnlocalizedName(tag);
            RailcraftRegistry.register(item);
        }
    }

    public static ItemStack getItemCharged() {
        return new ItemStack(item);
    }

    public static ItemStack getItemEmpty() {
        return new ItemStack(item, 1, item.getMaxDamage() - 1);
    }

    public ItemWaterstoneRefined() {
        this.setMaxStackSize(1);
        this.setMaxDamage(5000);
    }

    public void getSubItems(Item id, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 5000));
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        ItemStack newStack = stack.copy();
        newStack.stackSize = 1;
        newStack = InvTools.damageItem(newStack, 1);
        return newStack;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        ToolTip tip;
        super.addInformation(stack, player, info, adv);
        String tipTag = this.getUnlocalizedName() + ".tip.charged";
        if (stack.getItemDamage() >= stack.getMaxDamage() - 5) {
            tipTag = this.getUnlocalizedName() + ".tip.empty";
        }
        if ((tip = ToolTip.buildToolTip(tipTag, new String[0])) != null) {
            info.addAll(tip.convertToStrings());
        }
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        ItemStack cooked;
        ArrayList drops;
        Block block;
        if (player.canPlayerEdit(x, y, z, side, stack) && (block = WorldPlugin.getBlock((IBlockAccess)world, x, y, z)) != null && block != Blocks.stone && (drops = block.getDrops(world, x, y, z, world.getBlockMetadata(x, y, z), 0)).size() == 1 && drops.get(0) != null && ((ItemStack)drops.get(0)).getItem() instanceof ItemBlock && (cooked = FurnaceRecipes.smelting().getSmeltingResult((ItemStack)drops.get(0))) != null && cooked.getItem() instanceof ItemBlock) {
            int meta = !cooked.getItem().getHasSubtypes() ? 0 : cooked.getItem().getMetadata(cooked.getItemDamage());
            world.setBlock(x, y, z, InvTools.getBlockFromStack(cooked), meta, 3);
            world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, itemRand.nextFloat() * 0.4f + 0.8f);
            stack.damageItem(1, (EntityLivingBase)player);
            return true;
        }
        if (side == 0) {
            --y;
        }
        if (side == 1) {
            ++y;
        }
        if (side == 2) {
            --z;
        }
        if (side == 3) {
            ++z;
        }
        if (side == 4) {
            --x;
        }
        if (side == 5) {
            ++x;
        }
        if (player.canPlayerEdit(x, y, z, side, stack) && world.isAirBlock(x, y, z)) {
            world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, itemRand.nextFloat() * 0.4f + 0.8f);
            world.setBlock(x, y, z, (Block)Blocks.fire);
            stack.damageItem(1, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        EntityItemFirestone entity = new EntityItemFirestone(world, location.posX, location.posY, location.posZ, stack);
        entity.motionX = location.motionX;
        entity.motionY = location.motionY;
        entity.motionZ = location.motionZ;
        entity.delayBeforeCanPickup = 10;
        return entity;
    }
}

