/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import java.util.HashMap;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.tank.GenericMultiTankBase;
import mods.railcraft.common.blocks.machine.zeta.EnumMachineEta;
import mods.railcraft.common.blocks.machine.zeta.EnumMachineZeta;
import mods.railcraft.common.modules.RailcraftModule;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class ModuleAdvancedTanks
extends RailcraftModule {
    public static GenericMultiTankBase ALUMINIUM;
    public static GenericMultiTankBase STAINLESS;
    public static GenericMultiTankBase TITANIUM;
    public static GenericMultiTankBase TUNGSTENSTEEL;
    public static GenericMultiTankBase PALLADIUM;
    public static GenericMultiTankBase IRIDIUM;
    public static GenericMultiTankBase OSMIUM;
    public static GenericMultiTankBase NEUTRONIUM;
    public static final int CAPACITY_PER_BLOCK_ALUMINIUM = 64000;
    public static final int CAPACITY_PER_BLOCK_STAINLESS = 128000;
    public static final int CAPACITY_PER_BLOCK_TITANIUM = 512000;
    public static final int CAPACITY_PER_BLOCK_TUNGSTENSTEEL = 2048000;
    public static final int CAPACITY_PER_BLOCK_PALLADIUM = 0x7D0000;
    public static final int CAPACITY_PER_BLOCK_IRIDIUM = 32786000;
    public static final int CAPACITY_PER_BLOCK_OSMIUM = 131720000;
    public static final int CAPACITY_PER_BLOCK_NEUTRONIUM = 524288000;
    public static final HashMap<String, IEnumMachine> cacheTankType;
    public static final HashMap<String, GenericMultiTankBase> cacheTankMaterial;

    public static void initTanks() {
        ALUMINIUM = ModuleAdvancedTanks.createTank("aluminium", 64000, EnumMachineZeta.TANK_ALUMINIUM_WALL, EnumMachineZeta.TANK_ALUMINIUM_GAUGE, EnumMachineZeta.TANK_ALUMINIUM_VALVE);
        STAINLESS = ModuleAdvancedTanks.createTank("stainless", 128000, EnumMachineZeta.TANK_STAINLESS_WALL, EnumMachineZeta.TANK_STAINLESS_GAUGE, EnumMachineZeta.TANK_STAINLESS_VALVE);
        TITANIUM = ModuleAdvancedTanks.createTank("titanium", 512000, EnumMachineZeta.TANK_TITANIUM_WALL, EnumMachineZeta.TANK_TITANIUM_GAUGE, EnumMachineZeta.TANK_TITANIUM_VALVE);
        TUNGSTENSTEEL = ModuleAdvancedTanks.createTank("tungstensteel", 2048000, EnumMachineZeta.TANK_TUNGSTENSTEEL_WALL, EnumMachineZeta.TANK_TUNGSTENSTEEL_GAUGE, EnumMachineZeta.TANK_TUNGSTENSTEEL_VALVE);
        PALLADIUM = ModuleAdvancedTanks.createTank("palladium", 0x7D0000, EnumMachineZeta.TANK_PALLADIUM_WALL, EnumMachineZeta.TANK_PALLADIUM_GAUGE, EnumMachineZeta.TANK_PALLADIUM_VALVE);
        IRIDIUM = ModuleAdvancedTanks.createTank("iridium", 32786000, EnumMachineEta.TANK_IRIDIUM_WALL, EnumMachineEta.TANK_IRIDIUM_GAUGE, EnumMachineEta.TANK_IRIDIUM_VALVE);
        OSMIUM = ModuleAdvancedTanks.createTank("osmium", 131720000, EnumMachineEta.TANK_OSMIUM_WALL, EnumMachineEta.TANK_OSMIUM_GAUGE, EnumMachineEta.TANK_OSMIUM_VALVE);
        NEUTRONIUM = ModuleAdvancedTanks.createTank("neutronium", 524288000, EnumMachineEta.TANK_NEUTRONIUM_WALL, EnumMachineEta.TANK_NEUTRONIUM_GAUGE, EnumMachineEta.TANK_NEUTRONIUM_VALVE);
    }

    @Override
    public void initFirst() {
        ModuleAdvancedTanks.initTanks();
        this.initTankOfType(ALUMINIUM);
        this.initTankOfType(STAINLESS);
        this.initTankOfType(TITANIUM);
        this.initTankOfType(TUNGSTENSTEEL);
        this.initTankOfType(PALLADIUM);
        this.initTankOfType(IRIDIUM);
        this.initTankOfType(OSMIUM);
        this.initTankOfType(NEUTRONIUM);
    }

    private void initTankOfType(GenericMultiTankBase tankType) {
        String materialName = tankType.tankMaterial;
        String oredictName = "plate" + materialName.substring(0, 1).toUpperCase() + materialName.substring(1);
        ItemStack metalPlate = InvTools.getItemFromOreDict(oredictName, 1);
        this.defineTank(tankType.TANK_WALL, "PP", "PP", Character.valueOf('P'), metalPlate);
        this.defineTank(tankType.TANK_GAUGE, "GPG", "PGP", "GPG", Character.valueOf('P'), metalPlate, Character.valueOf('G'), "paneGlassColorless");
        this.defineTank(tankType.TANK_VALVE, "GPG", "PLP", "GPG", Character.valueOf('P'), metalPlate, Character.valueOf('L'), new ItemStack(Blocks.lever), Character.valueOf('G'), new ItemStack(Blocks.iron_bars));
    }

    private boolean defineTank(IEnumMachine type, Object ... recipe) {
        if (type instanceof EnumMachineZeta) {
            if (((EnumMachineZeta)type).register()) {
                this.addColorRecipes(type);
                CraftingPlugin.addShapedRecipe(this.getColorTank(type, EnumColor.WHITE, 8), recipe);
                return true;
            }
        } else if (type instanceof EnumMachineEta && ((EnumMachineEta)type).register()) {
            this.addColorRecipes(type);
            CraftingPlugin.addShapedRecipe(this.getColorTank(type, EnumColor.WHITE, 8), recipe);
            return true;
        }
        return false;
    }

    private void addColorRecipes(IEnumMachine type) {
        for (EnumColor color : EnumColor.VALUES) {
            ItemStack output = this.getColorTank(type, color, 8);
            CraftingPlugin.addShapedRecipe(output, "OOO", "ODO", "OOO", Character.valueOf('O'), type.getItem(), Character.valueOf('D'), color.getDye());
        }
    }

    private ItemStack getColorTank(IEnumMachine type, EnumColor color, int qty) {
        ItemStack stack = type.getItem(qty);
        return InvTools.setItemColor(stack, color);
    }

    private static GenericMultiTankBase createTank(String material, int capacity, IEnumMachine tankWall, IEnumMachine tankGauge, IEnumMachine tankValve) {
        GenericMultiTankBase tank = new GenericMultiTankBase(material, capacity, tankWall, tankValve, tankGauge);
        cacheTankMaterial.put(tankWall.getTag(), tank);
        cacheTankMaterial.put(tankGauge.getTag(), tank);
        cacheTankMaterial.put(tankValve.getTag(), tank);
        return tank;
    }

    static {
        cacheTankType = new HashMap();
        cacheTankMaterial = new HashMap();
    }
}

