/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.buildcraft.triggers;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementManager;
import java.util.EnumSet;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.common.blocks.machine.beta.TileEngine;
import mods.railcraft.common.plugins.buildcraft.triggers.Trigger;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerAspect;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerEngine;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerHasCart;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerHasWork;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerLowFuel;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerMaintenance;
import mods.railcraft.common.plugins.buildcraft.triggers.TriggerTemp;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public enum Triggers implements ITriggerExternal
{
    HAS_WORK("work", new TriggerHasWork()),
    HAS_CART("cart", new TriggerHasCart()),
    ENGINE_BLUE("engine.blue", new TriggerEngine(EnumSet.of(TileEngine.EnergyStage.BLUE))),
    ENGINE_GREEN("engine.green", new TriggerEngine(EnumSet.of(TileEngine.EnergyStage.GREEN))),
    ENGINE_YELLOW("engine.yellow", new TriggerEngine(EnumSet.of(TileEngine.EnergyStage.YELLOW))),
    ENGINE_ORANGE("engine.orange", new TriggerEngine(EnumSet.of(TileEngine.EnergyStage.ORANGE))),
    ENGINE_RED("engine.red", new TriggerEngine(EnumSet.of(TileEngine.EnergyStage.RED, TileEngine.EnergyStage.OVERHEAT))),
    LOW_FUEL("fuel", new TriggerLowFuel()),
    TEMP_COLD("temp.cold", new TriggerTemp(0, 100)),
    TEMP_WARM("temp.warm", new TriggerTemp(100, 300)),
    TEMP_HOT("temp.hot", new TriggerTemp(300, Integer.MAX_VALUE)),
    NEEDS_MAINT("maintenance", new TriggerMaintenance()),
    ASPECT_GREEN("aspect.green", new TriggerAspect(SignalAspect.GREEN)),
    ASPECT_BLINK_YELLOW("aspect.yellow.blink", new TriggerAspect(SignalAspect.BLINK_YELLOW)),
    ASPECT_YELLOW("aspect.yellow", new TriggerAspect(SignalAspect.YELLOW)),
    ASPECT_BLINK_RED("aspect.red.blink", new TriggerAspect(SignalAspect.BLINK_RED)),
    ASPECT_RED("aspect.red", new TriggerAspect(SignalAspect.RED)),
    ASPECT_OFF("aspect.off", new TriggerAspect(SignalAspect.OFF));

    public static final Triggers[] VALUES;
    private final Trigger trigger;
    private final String tag;
    private IIcon icon;

    private Triggers(String tag, Trigger trigger) {
        this.tag = tag;
        this.trigger = trigger;
    }

    public static void init() {
        for (Triggers trigger : VALUES) {
            StatementManager.registerStatement((IStatement)trigger);
            StatementManager.statements.put("railcraft." + trigger.tag, trigger);
        }
    }

    public String getUniqueTag() {
        return "railcraft:" + this.tag;
    }

    public IIcon getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return LocalizationPlugin.translate("gates.trigger." + this.tag);
    }

    public boolean isTriggerActive(TileEntity tile, ForgeDirection side, IStatementContainer isc, IStatementParameter[] parameter) {
        return this.trigger.isTriggerActive(side, tile, parameter);
    }

    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.registerIcon("railcraft:buildcraft.gate.trigger." + this.tag);
    }

    public int maxParameters() {
        return 0;
    }

    public int minParameters() {
        return 0;
    }

    public IStatementParameter createParameter(int i) {
        return null;
    }

    public IStatement rotateLeft() {
        return this;
    }

    static {
        VALUES = Triggers.values();
    }
}

