/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forestry;

import cpw.mods.fml.common.Optional;
import forestry.api.storage.IBackpackDefinition;
import mods.railcraft.api.core.items.IMinecartItem;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.detector.BlockDetector;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.signals.ItemSignalBlockSurveyor;
import mods.railcraft.common.blocks.signals.ItemSignalTuner;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.fluids.FluidContainers;
import mods.railcraft.common.items.ItemCrowbar;
import mods.railcraft.common.items.ItemCrowbarReinforced;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.items.ItemMagnifyingGlass;
import mods.railcraft.common.items.ItemWhistleTuner;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.plugins.forestry.BaseBackpack;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMinecart;

@Optional.Interface(iface="forestry.api.storage.IBackpackDefinition", modid="Forestry")
public class TrackmanBackpack
extends BaseBackpack
implements IBackpackDefinition {
    private static TrackmanBackpack instance;

    public static TrackmanBackpack getInstance() {
        if (instance == null) {
            instance = new TrackmanBackpack();
        }
        return instance;
    }

    protected TrackmanBackpack() {
    }

    public void setup() {
        this.addItem(ItemCrowbar.getItem());
        this.addItem(ItemCrowbarReinforced.getItem());
        this.addItem(ItemWhistleTuner.getItem());
        this.addItem(ItemMagnifyingGlass.getItem());
        this.addItem(ItemGoggles.getItem());
        this.addItem(ItemSignalBlockSurveyor.getItem());
        this.addItem(ItemSignalTuner.getItem());
        this.addItem(RailcraftToolItems.getOveralls());
        for (Object id : Block.blockRegistry.getKeys()) {
            Block block = (Block)Block.blockRegistry.getObject(id);
            if (block == null || !TrackTools.isRailBlock(block)) continue;
            this.addItem(block);
        }
        for (Object id : Item.itemRegistry.getKeys()) {
            Item item = (Item)Item.itemRegistry.getObject(id);
            if (!(item instanceof ItemMinecart) && !(item instanceof IMinecartItem)) continue;
            this.addItem(item);
        }
        this.addItem(FluidContainers.getCreosoteOilBottle());
        this.addItem(FluidContainers.getCreosoteOilBucket());
        this.addItem(FluidContainers.getCreosoteOilCell());
        this.addItem(FluidContainers.getCreosoteOilCan());
        this.addItem(FluidContainers.getCreosoteOilRefactory());
        this.addItem(FluidContainers.getCreosoteOilWax());
        this.addItem(EnumMachineAlpha.WORLD_ANCHOR.getItem());
        this.addItem(EnumMachineAlpha.PERSONAL_ANCHOR.getItem());
        this.addItem(EnumMachineBeta.SENTINEL.getItem());
        this.addItem(RailcraftItem.rail);
        this.addItem(RailcraftItem.railbed);
        this.addItem(RailcraftItem.tie);
        this.addItem(RailcraftItem.signalLamp);
        this.addItem(RailcraftItem.circuit);
        this.addItem(RailcraftItem.signalLabel);
        this.addItem(RailcraftBlocks.getBlockMachineGamma());
        this.addItem(RailcraftBlocks.getBlockElevator());
        this.addItem(RailcraftBlocks.getBlockSignal());
        this.addItem((Block)BlockDetector.getBlock());
    }

    public String getKey() {
        return "TRACKMAN";
    }

    public int getPrimaryColour() {
        return 38143;
    }

    public int getSecondaryColour() {
        return 0xFFFFFF;
    }
}

