/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forge;

import com.mojang.authlib.GameProfile;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ChatPlugin {
    public static IChatComponent getMessage(String msg) {
        return new ChatComponentText(msg);
    }

    public static IChatComponent chatComp(String msg, Object ... args) {
        return new ChatComponentTranslation(msg, args);
    }

    public static void sendLocalizedChat(EntityPlayer player, String msg, Object ... args) {
        player.addChatMessage(ChatPlugin.getMessage(String.format(LocalizationPlugin.translate(msg), args)));
    }

    public static void sendLocalizedChatFromClient(EntityPlayer player, String msg, Object ... args) {
        if (Game.isNotHost(player.worldObj)) {
            ChatPlugin.sendLocalizedChat(player, msg, args);
        }
    }

    public static void sendLocalizedChatFromServer(EntityPlayer player, String msg, Object ... args) {
        if (Game.isHost(player.worldObj)) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof String) {
                    args[i] = ChatPlugin.chatComp((String)args[i], new Object[0]);
                    continue;
                }
                if (!(args[i] instanceof GameProfile)) continue;
                String username = ((GameProfile)args[i]).getName();
                args[i] = username != null ? username : "[unknown]";
            }
            player.addChatMessage(ChatPlugin.chatComp(msg, args));
        }
    }

    public static void sendLocalizedChatToAllFromServer(World world, String msg, Object ... args) {
        if (world instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)world;
            for (Object obj : worldServer.playerEntities) {
                if (!(obj instanceof EntityPlayer)) continue;
                ChatPlugin.sendLocalizedChat((EntityPlayer)obj, msg, args);
            }
        }
    }
}

