/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forge;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictPlugin {
    public static boolean isOreType(String oreName, ItemStack stack) {
        ArrayList ores = OreDictionary.getOres((String)oreName);
        for (ItemStack ore : ores) {
            if (!InvTools.isItemEqual(ore, stack)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getOre(String name, int qty) {
        ArrayList ores = OreDictionary.getOres((String)name);
        for (ItemStack ore : ores) {
            if (InvTools.isWildcard(ore)) continue;
            ore = ore.copy();
            ore.stackSize = Math.min(qty, ore.getMaxStackSize());
            return ore;
        }
        return null;
    }

    public static boolean oreExists(String name) {
        return !OreDictionary.getOres((String)name).isEmpty();
    }

    public static Set<Block> getOreBlocks() {
        String[] names;
        HashSet<Block> ores = new HashSet<Block>();
        for (String name : names = OreDictionary.getOreNames()) {
            if (!name.startsWith("ore")) continue;
            for (ItemStack stack : OreDictionary.getOres((String)name)) {
                if (!(stack.getItem() instanceof ItemBlock)) continue;
                ores.add(InvTools.getBlockFromStack(stack));
            }
        }
        return ores;
    }
}

