/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.rf;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import mods.railcraft.common.util.misc.AdjacentTileCache;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RedstoneFluxPlugin {
    public static int pushToTile(TileEntity tile, ForgeDirection side, int powerToTransfer) {
        if (RedstoneFluxPlugin.canTileReceivePower(tile, side)) {
            IEnergyReceiver handler = (IEnergyReceiver)tile;
            if (powerToTransfer > 0) {
                return handler.receiveEnergy(side, powerToTransfer, false);
            }
        }
        return 0;
    }

    public static int pushToTiles(IEnergyProvider provider, AdjacentTileCache tileCache, int pushPerSide) {
        int pushed = 0;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = tileCache.getTileOnSide(side);
            if (!RedstoneFluxPlugin.canTileReceivePower(tile, side.getOpposite())) continue;
            IEnergyReceiver handler = (IEnergyReceiver)tile;
            int amountToPush = provider.extractEnergy(side, pushPerSide, true);
            if (amountToPush <= 0) continue;
            int amountPushed = handler.receiveEnergy(side.getOpposite(), amountToPush, false);
            pushed += amountPushed;
            provider.extractEnergy(side, amountPushed, false);
        }
        return pushed;
    }

    public static boolean canTileReceivePower(TileEntity tile, ForgeDirection side) {
        if (tile instanceof IEnergyReceiver) {
            IEnergyReceiver handler = (IEnergyReceiver)tile;
            return handler.canConnectEnergy(side);
        }
        return false;
    }
}

