/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.thaumcraft;

import cpw.mods.fml.common.Loader;
import java.util.HashMap;
import java.util.Map;
import mods.railcraft.common.blocks.aesthetics.brick.BlockBrick;
import mods.railcraft.common.blocks.aesthetics.brick.BrickVariant;
import mods.railcraft.common.blocks.aesthetics.brick.EnumBrick;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.blocks.aesthetics.glass.BlockStrengthGlass;
import mods.railcraft.common.blocks.anvil.BlockRCAnvil;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.items.ItemDust;
import mods.railcraft.common.items.ItemGear;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.items.ItemPlate;
import mods.railcraft.common.items.ItemRail;
import mods.railcraft.common.items.ItemTie;
import mods.railcraft.common.items.RailcraftItem;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.items.firestone.ItemFirestoneCracked;
import mods.railcraft.common.items.firestone.ItemFirestoneCut;
import mods.railcraft.common.items.firestone.ItemFirestoneRaw;
import mods.railcraft.common.items.firestone.ItemFirestoneRefined;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.EnumColor;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ItemApi;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchPage;

public class ThaumcraftPlugin {
    public static final String RESEARCH_CATEGORY = "RAILCRAFT";
    private static final Map<String, Item> itemCache = new HashMap<String, Item>();
    private static final Map<String, Boolean> itemCacheFlag = new HashMap<String, Boolean>();
    private static Map<String, ResearchPage> researchPages = new HashMap<String, ResearchPage>();
    private static Boolean modLoaded = null;

    public static ItemStack getItem(String tag, int meta) {
        if (!ThaumcraftPlugin.isModInstalled()) {
            return null;
        }
        Item item = itemCache.get(tag);
        if (item != null) {
            return new ItemStack(item, 1, meta);
        }
        Boolean wasCached = itemCacheFlag.get(tag);
        if (wasCached != null && wasCached.equals(Boolean.TRUE)) {
            return null;
        }
        try {
            itemCacheFlag.put(tag, Boolean.TRUE);
            ItemStack stack = ItemApi.getItem((String)tag, (int)meta);
            if (stack != null && stack.getItem() != null) {
                itemCache.put(tag, stack.getItem());
            }
            return stack;
        }
        catch (Throwable error) {
            Game.logErrorAPI("Thaumcraft", error, ItemApi.class);
            return null;
        }
    }

    public static void setupResearch() {
        ResearchCategories.registerCategory((String)RESEARCH_CATEGORY, (ResourceLocation)new ResourceLocation("railcraft", "textures/items/tool.crowbar.magic.png"), (ResourceLocation)new ResourceLocation("thaumcraft", "textures/gui/gui_researchback.png"));
    }

    private static ResearchPage createResearchPage(String key, int pageNum) {
        return new ResearchPage(LocalizationPlugin.translate(String.format("thaumcraft.research.%s.page.%d", key, pageNum)).replace("\n", "<BR>").replace("---", "<LINE>").replace("{img}", "<IMG>").replace("{/img}", "</IMG>"));
    }

    public static ResearchPage getResearchPage(String researchTag) {
        ResearchPage page = researchPages.get(researchTag);
        if (page == null) {
            page = ThaumcraftPlugin.createResearchPage(researchTag, 1);
            researchPages.put(researchTag, page);
        }
        return page;
    }

    public static void registerAspects() {
        try {
            AspectList anchorAspects = new AspectList().add(Aspect.ELDRITCH, 4).add(Aspect.ORDER, 4).add(Aspect.MAGIC, 2).add(Aspect.GREED, 2);
            AspectList steamAspects = new AspectList().add(Aspect.WATER, 3).add(Aspect.MECHANISM, 2).add(Aspect.FIRE, 3);
            AspectList tankAspects = new AspectList().add(Aspect.VOID, 4).add(Aspect.WATER, 4);
            ThaumcraftPlugin.addBrickAspects(EnumBrick.ABYSSAL, Aspect.DARKNESS);
            ThaumcraftPlugin.addBrickAspects(EnumBrick.BLEACHEDBONE, Aspect.DEATH);
            ThaumcraftPlugin.addBrickAspects(EnumBrick.BLOODSTAINED, Aspect.FLESH);
            ThaumcraftPlugin.addBrickAspects(EnumBrick.FROSTBOUND, Aspect.COLD);
            ThaumcraftPlugin.addBrickAspects(EnumBrick.INFERNAL, 2, Aspect.FIRE, Aspect.SOUL);
            ThaumcraftPlugin.addBrickAspects(EnumBrick.NETHER, Aspect.FIRE);
            ThaumcraftPlugin.addBrickAspects(EnumBrick.QUARRIED, Aspect.LIGHT);
            ThaumcraftPlugin.addBrickAspects(EnumBrick.SANDY, Aspect.EARTH);
            ThaumcraftPlugin.addItemAspect(EnumCube.ABYSSAL_STONE.getItem(), new AspectList().add(Aspect.EARTH, 4).add(Aspect.DARKNESS, 2));
            ThaumcraftPlugin.addItemAspect(EnumCube.QUARRIED_STONE.getItem(), new AspectList().add(Aspect.EARTH, 4).add(Aspect.LIGHT, 2));
            ThaumcraftPlugin.addItemAspect(EnumCube.CRUSHED_OBSIDIAN.getItem(), ThaumcraftPlugin.copyAspects(Blocks.obsidian).remove(Aspect.EARTH, 1).add(Aspect.ENTROPY, 1).add(Aspect.ELDRITCH, 1));
            ThaumcraftPlugin.addItemAspect(EnumCube.CONCRETE_BLOCK.getItem(), new AspectList().remove(Aspect.EARTH, 3).add(Aspect.METAL, 1));
            ThaumcraftPlugin.addItemAspect(EnumCube.CREOSOTE_BLOCK.getItem(), new AspectList().remove(Aspect.TREE, 3).add(Aspect.ORDER, 1));
            ThaumcraftPlugin.addItemAspect(EnumOre.DARK_DIAMOND.getItem(), ThaumcraftPlugin.copyAspects(Blocks.diamond_ore).add(Aspect.DARKNESS, 1));
            ThaumcraftPlugin.addItemAspect(EnumOre.DARK_EMERALD.getItem(), ThaumcraftPlugin.copyAspects(Blocks.emerald_ore).add(Aspect.DARKNESS, 1));
            ThaumcraftPlugin.addItemAspect(EnumOre.DARK_LAPIS.getItem(), ThaumcraftPlugin.copyAspects(Blocks.lapis_ore).add(Aspect.DARKNESS, 1));
            ThaumcraftPlugin.addItemAspect(EnumOre.SULFUR.getItem(), new AspectList().add(Aspect.EARTH, 1).add(Aspect.FIRE, 3));
            ThaumcraftPlugin.addItemAspect(EnumOre.SALTPETER.getItem(), new AspectList().add(Aspect.EARTH, 1).add(Aspect.AIR, 3));
            ThaumcraftPlugin.addItemAspect(EnumOre.FIRESTONE.getItem(), new AspectList().add(Aspect.EARTH, 1).add(Aspect.FIRE, 6).add(Aspect.ENTROPY, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.dust.getStack(ItemDust.EnumDust.SULFUR), new AspectList().add(Aspect.ENTROPY, 1).add(Aspect.FIRE, 3));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.dust.getStack(ItemDust.EnumDust.SALTPETER), new AspectList().add(Aspect.ENTROPY, 1).add(Aspect.AIR, 3));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.dust.getStack(ItemDust.EnumDust.CHARCOAL), new AspectList().add(Aspect.ENTROPY, 1).add(Aspect.FIRE, 2));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.dust.getStack(ItemDust.EnumDust.OBSIDIAN), ThaumcraftPlugin.copyAspects(Blocks.obsidian).remove(Aspect.EARTH, 2).add(Aspect.ENTROPY, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.rebar.getStack(), new AspectList().add(Aspect.METAL, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.rail.getStack(1, ItemRail.EnumRail.STANDARD), new AspectList().add(Aspect.METAL, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.rail.getStack(1, ItemRail.EnumRail.REINFORCED), new AspectList().add(Aspect.METAL, 1).add(Aspect.ORDER, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.rail.getStack(1, ItemRail.EnumRail.WOOD), new AspectList().add(Aspect.TREE, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.rail.getStack(1, ItemRail.EnumRail.ADVANCED), new AspectList().add(Aspect.METAL, 1).add(Aspect.MECHANISM, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.rail.getStack(1, ItemRail.EnumRail.SPEED), new AspectList().add(Aspect.METAL, 1).add(Aspect.TRAVEL, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.tie.getStack(1, ItemTie.EnumTie.WOOD), new AspectList().add(Aspect.TREE, 3).add(Aspect.ORDER, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.tie.getStack(1, ItemTie.EnumTie.STONE), new AspectList().add(Aspect.EARTH, 3).add(Aspect.METAL, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftToolItems.getCoalCoke(), new AspectList().add(Aspect.FIRE, 4).add(Aspect.ENERGY, 4));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.plate.getStack(1, ItemPlate.EnumPlate.IRON), new AspectList().add(Aspect.METAL, 4));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.plate.getStack(1, ItemPlate.EnumPlate.STEEL), new AspectList().add(Aspect.METAL, 3).add(Aspect.ORDER, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.plate.getStack(1, ItemPlate.EnumPlate.TIN), new AspectList().add(Aspect.METAL, 3));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.gear.getStack(ItemGear.EnumGear.GOLD_PLATE), new AspectList().add(Aspect.METAL, 4).add(Aspect.ORDER, 1).add(Aspect.MECHANISM, 2).add(Aspect.GREED, 2));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.gear.getStack(ItemGear.EnumGear.BUSHING), new AspectList().add(Aspect.METAL, 1).add(Aspect.ORDER, 1).add(Aspect.MECHANISM, 1));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.gear.getStack(ItemGear.EnumGear.IRON), new AspectList().add(Aspect.METAL, 4).add(Aspect.ORDER, 1).add(Aspect.MECHANISM, 4));
            ThaumcraftPlugin.addItemAspect(RailcraftItem.gear.getStack(ItemGear.EnumGear.STEEL), new AspectList().add(Aspect.METAL, 8).add(Aspect.ORDER, 2).add(Aspect.MECHANISM, 4));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.ROLLING_MACHINE.getItem(), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MECHANISM, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.ROCK_CRUSHER.getItem(), new AspectList().add(Aspect.CRAFT, 2).add(Aspect.MECHANISM, 4).add(Aspect.EARTH, 4).add(Aspect.EARTH, 4));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.FEED_STATION.getItem(), new AspectList().add(Aspect.CROP, 4).add(Aspect.HUNGER, 4).add(Aspect.MECHANISM, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.SMOKER.getItem(), new AspectList().add(Aspect.FIRE, 4).add(Aspect.AIR, 4).add(Aspect.MECHANISM, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.SMOKER.getItem(), new AspectList().add(Aspect.FIRE, 4).add(Aspect.AIR, 4).add(Aspect.MECHANISM, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.STEAM_TRAP_MANUAL.getItem(), steamAspects.copy().add(Aspect.TRAP, 4));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.STEAM_TRAP_AUTO.getItem(), steamAspects.copy().add(Aspect.TRAP, 4).add(Aspect.MIND, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.STEAM_OVEN.getItem(), steamAspects.copy().add(Aspect.FIRE, 3));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.TURBINE.getItem(), steamAspects.copy().add(Aspect.ENERGY, 4));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.ADMIN_ANCHOR.getItem(), anchorAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.PERSONAL_ANCHOR.getItem(), anchorAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.WORLD_ANCHOR.getItem(), anchorAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.SENTINEL.getItem(), anchorAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.BOILER_FIREBOX_SOLID.getItem(), steamAspects.copy().add(Aspect.ENERGY, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.BOILER_FIREBOX_FLUID.getItem(), steamAspects.copy().add(Aspect.ENERGY, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.BOILER_TANK_LOW_PRESSURE.getItem(), steamAspects.copy().add(Aspect.ENERGY, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.BOILER_TANK_HIGH_PRESSURE.getItem(), steamAspects.copy().add(Aspect.ENERGY, 2));
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.ENGINE_STEAM_HOBBY.getItem(), steamAspects.copy().add(Aspect.ENERGY, 4));
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.ENGINE_STEAM_LOW.getItem(), steamAspects.copy().add(Aspect.ENERGY, 4));
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.ENGINE_STEAM_HIGH.getItem(), steamAspects.copy().add(Aspect.ENERGY, 4));
            ThaumcraftPlugin.addItemAspect(EnumMachineAlpha.TANK_WATER.getItem(), tankAspects.copy().add(Aspect.TREE, 2).add(Aspect.SLIME, 2));
            AspectList ironTankAspects = tankAspects.copy().add(Aspect.METAL, 2);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.TANK_IRON_GAUGE.getItem(), ironTankAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.TANK_IRON_VALVE.getItem(), ironTankAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.TANK_IRON_WALL.getItem(), ironTankAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.TANK_STEEL_GAUGE.getItem(), ironTankAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.TANK_STEEL_VALVE.getItem(), ironTankAspects);
            ThaumcraftPlugin.addItemAspect(EnumMachineBeta.TANK_STEEL_WALL.getItem(), ironTankAspects);
            AspectList detectorAspects = new AspectList().add(Aspect.SENSES, 4).add(Aspect.MECHANISM, 4);
            for (EnumDetector detector : EnumDetector.VALUES) {
                ThaumcraftPlugin.addItemAspect(detector.getItem(), detectorAspects);
            }
            AspectList glassAspects = new AspectList().add(Aspect.CRYSTAL, 4).add(Aspect.METAL, 1);
            for (EnumColor color : EnumColor.VALUES) {
                ThaumcraftPlugin.addItemAspect(BlockStrengthGlass.getItem(color.ordinal()), glassAspects);
            }
            ThaumcraftPlugin.addItemAspect(BlockRCAnvil.getBlock(), new AspectList().add(Aspect.CRAFT, 4).add(Aspect.MAGIC, 2).add(Aspect.METAL, 4).add(Aspect.ORDER, 2));
            ThaumcraftPlugin.addCartAspect(EnumCart.LOCO_STEAM_SOLID, steamAspects.copy().add(Aspect.MOTION, 2).add(Aspect.TRAVEL, 4));
            ThaumcraftPlugin.addCartAspect(EnumCart.PUMPKIN, new AspectList(new ItemStack(Blocks.pumpkin)).add(Aspect.MOTION, 2).add(Aspect.ENTROPY, 6));
            ThaumcraftPlugin.addCartAspect(EnumCart.ANCHOR, anchorAspects.copy().add(Aspect.MOTION, 2).add(Aspect.TRAVEL, 2));
            ThaumcraftPlugin.addCartAspect(EnumCart.ANCHOR_ADMIN, anchorAspects.copy().add(Aspect.MOTION, 2).add(Aspect.TRAVEL, 2));
            ThaumcraftPlugin.addCartAspect(EnumCart.ANCHOR_PERSONAL, anchorAspects.copy().add(Aspect.MOTION, 2).add(Aspect.TRAVEL, 2));
            ThaumcraftPlugin.addItemAspect(ItemGoggles.getItem(), new AspectList().add(Aspect.AURA, 4).add(Aspect.SENSES, 4));
            ThaumcraftPlugin.addItemAspect(ItemFirestoneRaw.getItem(), new AspectList().add(Aspect.FIRE, 6).add(Aspect.CRYSTAL, 2).add(Aspect.ENTROPY, 4));
            ThaumcraftPlugin.addItemAspect(ItemFirestoneCut.getItem(), new AspectList().add(Aspect.FIRE, 6).add(Aspect.CRYSTAL, 2).add(Aspect.ENTROPY, 2).add(Aspect.ORDER, 2));
            ThaumcraftPlugin.addItemAspect(ItemFirestoneRefined.getItemCharged(), new AspectList().add(Aspect.FIRE, 6).add(Aspect.CRYSTAL, 2).add(Aspect.ORDER, 4));
            ThaumcraftPlugin.addItemAspect(ItemFirestoneCracked.getItemCharged(), new AspectList().add(Aspect.FIRE, 6).add(Aspect.CRYSTAL, 2).add(Aspect.ENTROPY, 4));
        }
        catch (Throwable error) {
            Game.logErrorAPI("Thaumcraft", error, ThaumcraftApi.class);
        }
    }

    public static AspectList copyAspects(Block block) {
        return new AspectList(new ItemStack(block, 1, Short.MAX_VALUE));
    }

    private static void addItemAspect(ItemStack stack, AspectList aspects) {
        if (stack == null) {
            return;
        }
        ThaumcraftApi.registerObjectTag((ItemStack)stack, (AspectList)aspects);
    }

    private static void addItemAspect(Block block, AspectList aspects) {
        if (block == null) {
            return;
        }
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(block, 1, Short.MAX_VALUE), (AspectList)aspects);
    }

    private static void addItemAspectComplex(ItemStack stack, AspectList aspects) {
        ThaumcraftApi.registerComplexObjectTag((ItemStack)stack, (AspectList)aspects);
    }

    private static void addCartAspect(ICartType cart, AspectList aspects) {
        ThaumcraftPlugin.addItemAspect(cart.getCartItem(), aspects);
        ThaumcraftApi.registerEntityTag((String)cart.getTag(), (AspectList)aspects, (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
    }

    private static void addBrickAspects(EnumBrick brick, Aspect baseAspect) {
        ThaumcraftPlugin.addBrickAspects(brick, 4, baseAspect);
    }

    private static void addBrickAspects(EnumBrick brick, int baseAmount, Aspect ... baseAspects) {
        BlockBrick block = brick.getBlock();
        if (block == null) {
            return;
        }
        AspectList aspects = new AspectList().add(Aspect.EARTH, 4);
        for (Aspect a : baseAspects) {
            aspects.add(a, baseAmount);
        }
        ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack((Block)block, 1, Short.MAX_VALUE), (AspectList)aspects);
        ThaumcraftApi.registerObjectTag((ItemStack)brick.get(BrickVariant.COBBLE), (AspectList)aspects.copy().remove(Aspect.EARTH, 2).add(Aspect.ENTROPY, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)brick.get(BrickVariant.BLOCK), (AspectList)aspects.copy().remove(Aspect.EARTH, 2).add(Aspect.ORDER, 2));
        ThaumcraftApi.registerObjectTag((ItemStack)brick.get(BrickVariant.ETCHED), (AspectList)aspects.copy().remove(Aspect.EARTH, 2).add(Aspect.GREED, 2));
    }

    public static Item.ToolMaterial getThaumiumToolMaterial() {
        try {
            return ThaumcraftApi.toolMatThaumium;
        }
        catch (Throwable error) {
            Game.logErrorAPI("Thaumcraft", error, ThaumcraftApi.class);
            return Item.ToolMaterial.IRON;
        }
    }

    public static Item.ToolMaterial getVoidmetalToolMaterial() {
        try {
            return ThaumcraftApi.toolMatVoid;
        }
        catch (Throwable error) {
            Game.logErrorAPI("Thaumcraft", error, ThaumcraftApi.class);
            return Item.ToolMaterial.IRON;
        }
    }

    public static boolean isModInstalled() {
        if (modLoaded == null) {
            modLoaded = Loader.isModLoaded((String)"Thaumcraft");
        }
        return modLoaded;
    }
}

