/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.collections;

import com.google.common.collect.ForwardingQueue;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import net.minecraft.util.Vec3;

public class CircularVec3Queue
extends ForwardingQueue<Vec3> {
    private final Vec3[] pool;
    private final ArrayDeque<Vec3> queue;
    private final int maxSize;
    private int poolIndex;

    public CircularVec3Queue(int maxSize) {
        this.maxSize = maxSize;
        this.pool = new Vec3[maxSize * 2];
        this.queue = new ArrayDeque(maxSize);
    }

    protected Queue<Vec3> delegate() {
        return this.queue;
    }

    public boolean add(double x, double y, double z) {
        if (this.maxSize == 0) {
            return true;
        }
        if (this.size() == this.maxSize) {
            this.queue.remove();
        }
        this.queue.add(this.getNextVec3(x, y, z));
        return true;
    }

    private Vec3 getNextVec3(double x, double y, double z) {
        if (this.poolIndex >= this.pool.length) {
            this.poolIndex = 0;
        }
        if (this.pool[this.poolIndex] == null) {
            Vec3 vec3 = Vec3.createVectorHelper((double)x, (double)y, (double)z);
            this.pool[this.poolIndex++] = vec3;
            return vec3;
        }
        this.pool[this.poolIndex].xCoord = x;
        this.pool[this.poolIndex].yCoord = y;
        this.pool[this.poolIndex].zCoord = z;
        return this.pool[this.poolIndex++];
    }

    public Iterator<Vec3> descendingIterator() {
        return this.queue.descendingIterator();
    }

    public Iterable<Vec3> descendingIterable() {
        return new Iterable<Vec3>(){

            @Override
            public Iterator<Vec3> iterator() {
                return CircularVec3Queue.this.queue.descendingIterator();
            }
        };
    }
}

