/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.crafting;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.crafting.ICokeOvenCraftingManager;
import mods.railcraft.api.crafting.ICokeOvenRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CokeOvenCraftingManager
implements ICokeOvenCraftingManager {
    private final List<CokeOvenRecipe> recipes = new ArrayList<CokeOvenRecipe>();

    public static ICokeOvenCraftingManager getInstance() {
        return RailcraftCraftingManager.cokeOven;
    }

    @Override
    public List<? extends ICokeOvenRecipe> getRecipes() {
        return this.recipes;
    }

    @Override
    public void addRecipe(ItemStack input, boolean matchDamage, boolean matchNBT, ItemStack output, FluidStack fluidOutput, int cookTime) {
        if (input == null) {
            return;
        }
        this.recipes.add(new CokeOvenRecipe(input, matchDamage, matchNBT, output, fluidOutput, cookTime));
    }

    @Override
    public ICokeOvenRecipe getRecipe(ItemStack input) {
        if (input == null) {
            return null;
        }
        for (CokeOvenRecipe r : this.recipes) {
            if (!r.matchDamage || InvTools.isWildcard(r.input) || !InvTools.isItemEqual(input, r.input, true, r.matchNBT)) continue;
            return r;
        }
        for (CokeOvenRecipe r : this.recipes) {
            if (!InvTools.isItemEqual(input, r.input, r.matchDamage, r.matchNBT)) continue;
            return r;
        }
        return null;
    }

    public static class CokeOvenRecipe
    implements ICokeOvenRecipe {
        private final ItemStack input;
        private final boolean matchDamage;
        private final boolean matchNBT;
        private final FluidStack fluidOutput;
        private final int cookTime;
        private final ItemStack output;

        public CokeOvenRecipe(ItemStack input, boolean matchDamage, boolean matchNBT, ItemStack output, FluidStack fluidOutput, int cookTime) {
            this.input = input;
            this.matchDamage = matchDamage;
            this.matchNBT = matchNBT;
            this.output = output;
            this.fluidOutput = fluidOutput;
            this.cookTime = cookTime;
        }

        @Override
        public ItemStack getInput() {
            return this.input.copy();
        }

        @Override
        public ItemStack getOutput() {
            if (this.output == null) {
                return null;
            }
            return this.output.copy();
        }

        @Override
        public FluidStack getFluidOutput() {
            if (this.fluidOutput != null) {
                return this.fluidOutput.copy();
            }
            return null;
        }

        @Override
        public int getCookTime() {
            return this.cookTime;
        }
    }
}

