/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.crafting;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import mods.railcraft.common.carts.EntityCartFiltered;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.items.firestone.ItemFirestoneCracked;
import mods.railcraft.common.util.crafting.CartFilterRecipe;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.IInvSlot;
import mods.railcraft.common.util.inventory.wrappers.InventoryIterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CraftingHandler {
    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        EntityPlayer player = event.player;
        ItemStack result = event.crafting;
        IInventory craftMatrix = event.craftMatrix;
        int count = 0;
        ItemStack cartItem = null;
        for (int i = 0; i < craftMatrix.getSizeInventory(); ++i) {
            ICartType cartType;
            ItemStack stack = craftMatrix.getStackInSlot(i);
            if (stack == null) continue;
            ++count;
            if (stack.getItem() == ItemFirestoneCracked.item) {
                craftMatrix.setInventorySlotContents(i, null);
            }
            if ((cartType = EnumCart.getCartType(stack)) == null || cartType == EnumCart.BASIC) continue;
            cartItem = stack;
        }
        if (cartItem != null) {
            ItemStack contents;
            CartFilterRecipe.FilterType type = CartFilterRecipe.FilterType.fromCartType(EnumCart.getCartType(cartItem));
            if (type != null && EnumCart.getCartType(result) == EnumCart.getCartType(cartItem)) {
                ItemStack filterItem = EntityCartFiltered.getFilterFromCartItem(result);
                if (filterItem != null) {
                    for (IInvSlot slot : InventoryIterator.getIterable(craftMatrix).notNull()) {
                        ItemStack stack = slot.getStackInSlot();
                        if (!InvTools.isItemEqual(stack, filterItem)) continue;
                        if (cartItem.stackSize == 1) {
                            if (!player.inventory.addItemStackToInventory(stack)) {
                                player.dropPlayerItemWithRandomChoice(stack, false);
                            }
                            slot.setStackInSlot(null);
                            continue;
                        }
                        ++stack.stackSize;
                    }
                }
                return;
            }
            if (count == 1 && EnumCart.getCartType(result) == EnumCart.BASIC && (contents = EnumCart.getCartType(cartItem).getContents()) != null && !player.inventory.addItemStackToInventory(contents)) {
                player.dropPlayerItemWithRandomChoice(contents, false);
            }
        }
    }
}

