/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.crafting;

import mods.railcraft.common.items.ItemRoutingTable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RoutingTableCopyRecipe
implements IRecipe {
    public boolean matches(InventoryCrafting grid, World world) {
        ItemStack source = grid.getStackInSlot(0);
        if (source == null || source.getItem() != ItemRoutingTable.item || source.stackSize > 1) {
            return false;
        }
        int numCopies = 0;
        for (int slot = 1; slot < grid.getSizeInventory(); ++slot) {
            ItemStack stack = grid.getStackInSlot(slot);
            if (stack == null) continue;
            if (stack.getItem() == ItemRoutingTable.item) {
                ++numCopies;
                continue;
            }
            return false;
        }
        return numCopies > 0;
    }

    public ItemStack getCraftingResult(InventoryCrafting grid) {
        ItemStack source = grid.getStackInSlot(0);
        if (source != null && source.getItem() == ItemRoutingTable.item && source.stackSize == 1) {
            int copies = 0;
            for (int slot = 1; slot < grid.getSizeInventory(); ++slot) {
                ItemStack stack = grid.getStackInSlot(slot);
                if (stack == null || stack.getItem() != ItemRoutingTable.item) continue;
                ++copies;
            }
            if (copies > 0) {
                ItemStack dest = source.copy();
                dest.stackSize = copies + 1;
                return dest;
            }
        }
        return null;
    }

    public int getRecipeSize() {
        return 2;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }
}

