/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class ItemStackMap<V>
implements Map<ItemStack, V> {
    private final Map<KeyWrapper, V> map = new HashMap<KeyWrapper, V>();

    @Override
    public V put(ItemStack stack, V value) {
        return this.map.put(new KeyWrapper(stack), value);
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public V remove(Object key) {
        if (key instanceof ItemStack) {
            return this.map.remove(new KeyWrapper((ItemStack)key));
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public V get(Object key) {
        if (key instanceof ItemStack) {
            return this.map.get(new KeyWrapper((ItemStack)key));
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ItemStackMap) {
            return this.map.equals(((ItemStackMap)o).map);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof ItemStack) {
            return this.map.containsKey(new KeyWrapper((ItemStack)key));
        }
        return false;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void putAll(Map<? extends ItemStack, ? extends V> m) {
        for (Map.Entry<ItemStack, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Set<ItemStack> keySet() {
        HashSet<ItemStack> keySet = new HashSet<ItemStack>();
        for (KeyWrapper w : this.map.keySet()) {
            keySet.add(w.getStack());
        }
        return keySet;
    }

    @Override
    public Set<Map.Entry<ItemStack, V>> entrySet() {
        HashSet<Map.Entry<ItemStack, V>> entrySet = new HashSet<Map.Entry<ItemStack, V>>();
        for (Map.Entry<KeyWrapper, V> entry : this.map.entrySet()) {
            entrySet.add(new EntryWrapper(entry));
        }
        return entrySet;
    }

    private static class KeyWrapper {
        private final ItemStack stack;

        public KeyWrapper(ItemStack stack) {
            this.stack = stack.copy();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyWrapper other = (KeyWrapper)obj;
            if (this.stack.getItem() != other.stack.getItem()) {
                return false;
            }
            return this.stack.getItemDamage() == other.stack.getItemDamage();
        }

        public int hashCode() {
            int hash = 5;
            hash = 23 * hash + this.stack.getItem().hashCode();
            hash = 23 * hash + this.stack.getItemDamage();
            return hash;
        }

        public ItemStack getStack() {
            return this.stack.copy();
        }
    }

    private class EntryWrapper
    implements Map.Entry<ItemStack, V> {
        private final Map.Entry<KeyWrapper, V> entry;

        public EntryWrapper(Map.Entry<KeyWrapper, V> e) {
            this.entry = e;
        }

        @Override
        public ItemStack getKey() {
            return this.entry.getKey().getStack();
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.entry.setValue(value);
        }

        public String toString() {
            return this.getKey().getItem().getUnlocalizedName() + "=" + this.getValue().toString();
        }
    }
}

