/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory.filters;

import mods.railcraft.api.core.items.IMinecartItem;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.api.core.items.ITrackItem;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.misc.BallastRegistry;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;

public enum StackFilter implements IStackFilter
{
    ALL{

        @Override
        public boolean matches(ItemStack stack) {
            return true;
        }
    }
    ,
    FUEL{

        @Override
        public boolean matches(ItemStack stack) {
            return FuelPlugin.getBurnTime(stack) > 0;
        }
    }
    ,
    TRACK{

        @Override
        public boolean matches(ItemStack stack) {
            return stack.getItem() instanceof ITrackItem || stack.getItem() instanceof ItemBlock && TrackTools.isRailBlock(((ItemBlock)stack.getItem()).field_150939_a);
        }
    }
    ,
    MINECART{

        @Override
        public boolean matches(ItemStack stack) {
            return stack.getItem() instanceof ItemMinecart || stack.getItem() instanceof IMinecartItem;
        }
    }
    ,
    BALLAST{

        @Override
        public boolean matches(ItemStack stack) {
            return BallastRegistry.isItemBallast(stack);
        }
    }
    ,
    EMPTY_BUCKET{

        @Override
        public boolean matches(ItemStack stack) {
            return stack != null && stack.getItem() == Items.bucket;
        }
    }
    ,
    FEED{

        @Override
        public boolean matches(ItemStack stack) {
            return stack.getItem() instanceof ItemFood || stack.getItem() == Items.wheat || stack.getItem() instanceof ItemSeeds;
        }
    };


    public static void initialize() {
        for (StackFilter type : StackFilter.values()) {
            IStackFilter.filters.put(type.name(), type);
        }
    }

    @Override
    public abstract boolean matches(ItemStack var1);
}

