/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory.wrappers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;

public class ChestWrapper
implements IInventory {
    private final TileEntityChest upperChest;
    private TileEntityChest lowerChest;

    public ChestWrapper(TileEntityChest tile) {
        this.upperChest = tile;
        this.checkChest();
    }

    private void checkChest() {
        if (this.lowerChest == null || this.lowerChest.isInvalid()) {
            this.lowerChest = this.upperChest.adjacentChestXNeg != null ? this.upperChest.adjacentChestXNeg : (this.upperChest.adjacentChestXPos != null ? this.upperChest.adjacentChestXPos : (this.upperChest.adjacentChestZNeg != null ? this.upperChest.adjacentChestZNeg : (this.upperChest.adjacentChestZPos != null ? this.upperChest.adjacentChestZPos : null)));
        }
    }

    public int getSizeInventory() {
        this.checkChest();
        int size = this.upperChest.getSizeInventory();
        if (this.lowerChest != null) {
            size += this.lowerChest.getSizeInventory();
        }
        return size;
    }

    public boolean isPartOfLargeChest(IInventory inv) {
        return this.upperChest == inv || this.lowerChest == inv;
    }

    public String getInventoryName() {
        return "";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public ItemStack getStackInSlot(int slot) {
        this.checkChest();
        if (slot >= this.upperChest.getSizeInventory() && this.lowerChest != null) {
            return this.lowerChest.getStackInSlot(slot - this.upperChest.getSizeInventory());
        }
        return this.upperChest.getStackInSlot(slot);
    }

    public ItemStack decrStackSize(int slot, int amout) {
        this.checkChest();
        if (slot >= this.upperChest.getSizeInventory() && this.lowerChest != null) {
            return this.lowerChest.decrStackSize(slot - this.upperChest.getSizeInventory(), amout);
        }
        return this.upperChest.decrStackSize(slot, amout);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        this.checkChest();
        if (slot >= this.upperChest.getSizeInventory() && this.lowerChest != null) {
            return this.lowerChest.getStackInSlotOnClosing(slot - this.upperChest.getSizeInventory());
        }
        return this.upperChest.getStackInSlotOnClosing(slot);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.checkChest();
        if (slot >= this.upperChest.getSizeInventory() && this.lowerChest != null) {
            this.lowerChest.setInventorySlotContents(slot - this.upperChest.getSizeInventory(), stack);
        } else {
            this.upperChest.setInventorySlotContents(slot, stack);
        }
    }

    public int getInventoryStackLimit() {
        return this.upperChest.getInventoryStackLimit();
    }

    public void markDirty() {
        this.upperChest.markDirty();
        if (this.lowerChest != null) {
            this.lowerChest.markDirty();
        }
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.upperChest.isUseableByPlayer(player) && (this.lowerChest == null || this.lowerChest.isUseableByPlayer(player));
    }

    public void openInventory() {
        this.upperChest.openInventory();
        if (this.lowerChest != null) {
            this.lowerChest.openInventory();
        }
    }

    public void closeInventory() {
        this.upperChest.closeInventory();
        if (this.lowerChest != null) {
            this.lowerChest.closeInventory();
        }
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return true;
    }
}

