/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory.wrappers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class SidedInventoryMapper
implements ISidedInventory {
    private final ISidedInventory inv;
    private final int side;
    private boolean checkItems = true;

    public SidedInventoryMapper(ISidedInventory inv, ForgeDirection side) {
        this(inv, side, true);
    }

    public SidedInventoryMapper(ISidedInventory inv, ForgeDirection side, boolean checkItems) {
        this.inv = inv;
        this.side = side.ordinal();
        this.checkItems = checkItems;
    }

    public IInventory getBaseInventory() {
        return this.inv;
    }

    public int getSizeInventory() {
        return this.inv.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inv.getStackInSlot(slot);
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return this.inv.decrStackSize(slot, amount);
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        this.inv.setInventorySlotContents(slot, itemstack);
    }

    public String getInventoryName() {
        return this.inv.getInventoryName();
    }

    public int getInventoryStackLimit() {
        return this.inv.getInventoryStackLimit();
    }

    public void markDirty() {
        this.inv.markDirty();
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.inv.isUseableByPlayer(entityplayer);
    }

    public void openInventory() {
        this.inv.openInventory();
    }

    public void closeInventory() {
        this.inv.closeInventory();
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.inv.getStackInSlotOnClosing(slot);
    }

    public boolean hasCustomInventoryName() {
        return this.inv.hasCustomInventoryName();
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return !this.checkItems || this.inv.isItemValidForSlot(slot, stack);
    }

    public int[] getAccessibleSlotsFromSide(int s) {
        return this.inv.getAccessibleSlotsFromSide(this.side);
    }

    public boolean canInsertItem(int slot, ItemStack stack, int s) {
        return !this.checkItems || this.inv.canInsertItem(slot, stack, this.side);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int s) {
        return !this.checkItems || this.inv.canExtractItem(slot, stack, this.side);
    }
}

