/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.Timer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public final class AdjacentTileCache {
    private static final int DELAY_MIN = 20;
    private static final int DELAY_MAX = 2400;
    private static final int DELAY_STEP = 2;
    private final Timer[] timer = new Timer[6];
    private final TileEntity[] cache = new TileEntity[6];
    private final int[] delay = new int[6];
    private final TileEntity source;
    private final Set<ICacheListener> listeners = new LinkedHashSet<ICacheListener>();

    public AdjacentTileCache(TileEntity tile) {
        this.source = tile;
        Arrays.fill(this.delay, 20);
        for (int i = 0; i < this.timer.length; ++i) {
            this.timer[i] = new Timer();
        }
    }

    public void addListener(ICacheListener listener) {
        this.listeners.add(listener);
    }

    private TileEntity searchSide(ForgeDirection side) {
        return WorldPlugin.getTileEntityOnSide(this.source.getWorldObj(), this.source.xCoord, this.source.yCoord, this.source.zCoord, side);
    }

    public void refresh() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.getTileOnSide(side);
        }
    }

    public Map<ForgeDirection, TileEntity> refreshTiles() {
        EnumMap<ForgeDirection, TileEntity> tiles = new EnumMap<ForgeDirection, TileEntity>(ForgeDirection.class);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            tiles.put(side, this.getTileOnSide(side));
        }
        return tiles;
    }

    public void purge() {
        Arrays.fill(this.cache, null);
        Arrays.fill(this.delay, 20);
        for (Timer t : this.timer) {
            t.reset();
        }
        for (ICacheListener listener : this.listeners) {
            listener.purge();
        }
    }

    public void onNeighborChange() {
        Arrays.fill(this.delay, 20);
    }

    protected void setTile(ForgeDirection side, TileEntity tile) {
        int s = side.ordinal();
        if (this.cache[s] != tile) {
            this.cache[s] = tile;
            this.changed(side);
        }
    }

    private void changed(ForgeDirection side) {
        for (ICacheListener listener : this.listeners) {
            listener.changed(side);
        }
    }

    private boolean isInSameChunk(ForgeDirection side) {
        int sx = MiscTools.getXOnSide(this.source.xCoord, side);
        int sz = MiscTools.getZOnSide(this.source.zCoord, side);
        return this.source.xCoord >> 4 == sx >> 4 && this.source.zCoord >> 4 == sz >> 4;
    }

    public TileEntity getTileOnSide(ForgeDirection side) {
        if (Game.IS_BUKKIT || !this.isInSameChunk(side)) {
            this.changed(side);
            return this.searchSide(side);
        }
        int s = side.ordinal();
        if (this.cache[s] != null) {
            if (this.cache[s].isInvalid() || !MiscTools.areCoordinatesOnSide(this.source.xCoord, this.source.yCoord, this.source.zCoord, side, this.cache[s].xCoord, this.cache[s].yCoord, this.cache[s].zCoord)) {
                this.setTile(side, null);
            } else {
                return this.cache[s];
            }
        }
        if (this.timer[s].hasTriggered(this.source.getWorldObj(), this.delay[s])) {
            this.setTile(side, this.searchSide(side));
            if (this.cache[s] == null) {
                this.incrementDelay(s);
            } else {
                this.delay[s] = 20;
            }
        }
        return this.cache[s];
    }

    private void incrementDelay(int side) {
        int n = side;
        this.delay[n] = this.delay[n] + 2;
        if (this.delay[side] > 2400) {
            this.delay[side] = 2400;
        }
    }

    public List<String> getDebugOutput() {
        ArrayList<String> debug = new ArrayList<String>();
        debug.add("Neighbor Cache: " + Arrays.toString(this.cache));
        return debug;
    }

    public static interface ICacheListener {
        public void changed(ForgeDirection var1);

        public void purge();
    }
}

