/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.misc;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MiscTools {
    public static final Random RANDOM = new Random();

    public static Random getRand() {
        return RANDOM;
    }

    public static void registerTrack(EnumTrack rail) {
        RailcraftBlocks.registerBlockTrack();
        if (RailcraftBlocks.getBlockTrack() != null && RailcraftConfig.isSubBlockEnabled(rail.getTag())) {
            rail.initialize();
            ItemStack stack = rail.getTrackSpec().getItem();
            RailcraftRegistry.register(stack);
        }
    }

    public static String cleanTag(String tag) {
        return tag.replaceAll("[Rr]ailcraft\\p{Punct}", "").replaceFirst("^tile\\.", "").replaceFirst("^item\\.", "");
    }

    public static void writeUUID(NBTTagCompound data, String tag, UUID uuid) {
        if (uuid == null) {
            return;
        }
        NBTTagCompound nbtTag = new NBTTagCompound();
        nbtTag.setLong("most", uuid.getMostSignificantBits());
        nbtTag.setLong("least", uuid.getLeastSignificantBits());
        data.setTag(tag, (NBTBase)nbtTag);
    }

    public static UUID readUUID(NBTTagCompound data, String tag) {
        if (data.hasKey(tag)) {
            NBTTagCompound nbtTag = data.getCompoundTag(tag);
            return new UUID(nbtTag.getLong("most"), nbtTag.getLong("least"));
        }
        return null;
    }

    public static AxisAlignedBB addCoordToAABB(AxisAlignedBB box, double x, double y, double z) {
        if (x < box.minX) {
            box.minX = x;
        } else if (x > box.maxX) {
            box.maxX = x;
        }
        if (y < box.minY) {
            box.minY = y;
        } else if (y > box.maxY) {
            box.maxY = y;
        }
        if (z < box.minZ) {
            box.minZ = z;
        } else if (z > box.maxZ) {
            box.maxZ = z;
        }
        return box;
    }

    public static <T extends Entity> List<T> getNearbyEntities(World world, Class<T> entityClass, float x, float minY, float maxY, float z, float radius) {
        AxisAlignedBB box = AxisAlignedBB.getBoundingBox((double)x, (double)minY, (double)z, (double)(x + 1.0f), (double)maxY, (double)(z + 1.0f));
        box = box.expand((double)radius, 0.0, (double)radius);
        return world.getEntitiesWithinAABB(entityClass, box);
    }

    public static <T extends Entity> List<T> getEntitiesAt(World world, Class<T> entityClass, int x, int y, int z) {
        AxisAlignedBB box = AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        return world.selectEntitiesWithinAABB(entityClass, box, IEntitySelector.selectAnything);
    }

    public static <T extends Entity> T getEntityAt(World world, Class<T> entityClass, int x, int y, int z) {
        AxisAlignedBB box = AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        List entities = world.selectEntitiesWithinAABB(entityClass, box, IEntitySelector.selectAnything);
        if (!entities.isEmpty()) {
            return (T)((Entity)entities.get(0));
        }
        return null;
    }

    public static MovingObjectPosition collisionRayTrace(Vec3 vec3d, Vec3 vec3d1, int i, int j, int k) {
        vec3d = vec3d.addVector((double)(-i), (double)(-j), (double)(-k));
        vec3d1 = vec3d1.addVector((double)(-i), (double)(-j), (double)(-k));
        Vec3 vec3d2 = vec3d.getIntermediateWithXValue(vec3d1, 0.0);
        Vec3 vec3d3 = vec3d.getIntermediateWithXValue(vec3d1, 1.0);
        Vec3 vec3d4 = vec3d.getIntermediateWithYValue(vec3d1, 0.0);
        Vec3 vec3d5 = vec3d.getIntermediateWithYValue(vec3d1, 1.0);
        Vec3 vec3d6 = vec3d.getIntermediateWithZValue(vec3d1, 0.0);
        Vec3 vec3d7 = vec3d.getIntermediateWithZValue(vec3d1, 1.0);
        if (!MiscTools.isVecInsideYZBounds(vec3d2)) {
            vec3d2 = null;
        }
        if (!MiscTools.isVecInsideYZBounds(vec3d3)) {
            vec3d3 = null;
        }
        if (!MiscTools.isVecInsideXZBounds(vec3d4)) {
            vec3d4 = null;
        }
        if (!MiscTools.isVecInsideXZBounds(vec3d5)) {
            vec3d5 = null;
        }
        if (!MiscTools.isVecInsideXYBounds(vec3d6)) {
            vec3d6 = null;
        }
        if (!MiscTools.isVecInsideXYBounds(vec3d7)) {
            vec3d7 = null;
        }
        Vec3 vec3d8 = null;
        if (vec3d2 != null && (vec3d8 == null || vec3d.distanceTo(vec3d2) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d2;
        }
        if (vec3d3 != null && (vec3d8 == null || vec3d.distanceTo(vec3d3) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d3;
        }
        if (vec3d4 != null && (vec3d8 == null || vec3d.distanceTo(vec3d4) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d4;
        }
        if (vec3d5 != null && (vec3d8 == null || vec3d.distanceTo(vec3d5) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d5;
        }
        if (vec3d6 != null && (vec3d8 == null || vec3d.distanceTo(vec3d6) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d6;
        }
        if (vec3d7 != null && (vec3d8 == null || vec3d.distanceTo(vec3d7) < vec3d.distanceTo(vec3d8))) {
            vec3d8 = vec3d7;
        }
        if (vec3d8 == null) {
            return null;
        }
        int byte0 = -1;
        if (vec3d8 == vec3d2) {
            byte0 = 4;
        }
        if (vec3d8 == vec3d3) {
            byte0 = 5;
        }
        if (vec3d8 == vec3d4) {
            byte0 = 0;
        }
        if (vec3d8 == vec3d5) {
            byte0 = 1;
        }
        if (vec3d8 == vec3d6) {
            byte0 = 2;
        }
        if (vec3d8 == vec3d7) {
            byte0 = 3;
        }
        return new MovingObjectPosition(i, j, k, byte0, vec3d8.addVector((double)i, (double)j, (double)k));
    }

    private static boolean isVecInsideYZBounds(Vec3 vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.yCoord >= 0.0 && vec3d.yCoord <= 1.0 && vec3d.zCoord >= 0.0 && vec3d.zCoord <= 1.0;
    }

    private static boolean isVecInsideXZBounds(Vec3 vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= 0.0 && vec3d.xCoord <= 1.0 && vec3d.zCoord >= 0.0 && vec3d.zCoord <= 1.0;
    }

    private static boolean isVecInsideXYBounds(Vec3 vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.xCoord >= 0.0 && vec3d.xCoord <= 1.0 && vec3d.yCoord >= 0.0 && vec3d.yCoord <= 1.0;
    }

    public static MovingObjectPosition rayTracePlayerLook(EntityPlayer player) {
        double distance = player.capabilities.isCreativeMode ? 5.0 : 4.5;
        Vec3 posVec = Vec3.createVectorHelper((double)player.posX, (double)player.posY, (double)player.posZ);
        Vec3 lookVec = player.getLook(1.0f);
        posVec.yCoord += (double)player.getEyeHeight();
        lookVec = posVec.addVector(lookVec.xCoord * distance, lookVec.yCoord * distance, lookVec.zCoord * distance);
        return player.worldObj.rayTraceBlocks(posVec, lookVec);
    }

    public static ForgeDirection getCurrentMousedOverSide(EntityPlayer player) {
        MovingObjectPosition mouseOver = MiscTools.rayTracePlayerLook(player);
        if (mouseOver != null) {
            return ForgeDirection.getOrientation((int)mouseOver.sideHit);
        }
        return ForgeDirection.UNKNOWN;
    }

    public static ForgeDirection getSideClosestToPlayer(World world, int i, int j, int k, EntityLivingBase entityplayer) {
        if (MathHelper.abs((float)((float)entityplayer.posX - (float)i)) < 2.0f && MathHelper.abs((float)((float)entityplayer.posZ - (float)k)) < 2.0f) {
            double d = entityplayer.posY + 1.82 - (double)entityplayer.yOffset;
            if (d - (double)j > 2.0) {
                return ForgeDirection.UP;
            }
            if ((double)j - d > 0.0) {
                return ForgeDirection.DOWN;
            }
        }
        int dir = MathHelper.floor_double((double)((double)(entityplayer.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        switch (dir) {
            case 0: {
                return ForgeDirection.NORTH;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
        }
        return dir != 3 ? ForgeDirection.DOWN : ForgeDirection.WEST;
    }

    public static ForgeDirection getSideFacingTrack(World world, int x, int y, int z) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!TrackTools.isRailBlockAt((IBlockAccess)world, MiscTools.getXOnSide(x, dir), MiscTools.getYOnSide(y, dir), MiscTools.getZOnSide(z, dir))) continue;
            return dir;
        }
        return ForgeDirection.UNKNOWN;
    }

    public static ForgeDirection getHorizontalSideClosestToPlayer(World world, int x, int y, int z, EntityLivingBase player) {
        int dir = MathHelper.floor_double((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        switch (dir) {
            case 0: {
                return ForgeDirection.NORTH;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
        }
        return ForgeDirection.NORTH;
    }

    public static ForgeDirection getOppositeSide(int side) {
        int s = side;
        s = s % 2 == 0 ? s + 1 : s - 1;
        return ForgeDirection.getOrientation((int)s);
    }

    public static int getXOnSide(int x, ForgeDirection side) {
        return x + side.offsetX;
    }

    public static int getYOnSide(int y, ForgeDirection side) {
        return y + side.offsetY;
    }

    public static int getZOnSide(int z, ForgeDirection side) {
        return z + side.offsetZ;
    }

    public static boolean areCoordinatesOnSide(int x, int y, int z, ForgeDirection side, int xCoord, int yCoord, int zCoord) {
        return x + side.offsetX == xCoord && y + side.offsetY == yCoord && z + side.offsetZ == zCoord;
    }

    public static boolean isKillabledEntity(Entity entity) {
        if (entity.ridingEntity instanceof EntityMinecart) {
            return false;
        }
        if (!(entity instanceof EntityLivingBase)) {
            return false;
        }
        return ((EntityLivingBase)entity).getMaxHealth() < 100.0f;
    }

    public static enum ArmorSlots {
        BOOTS,
        LEGS,
        CHEST,
        HELM;

    }
}

