/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketHandler;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.world.WorldServer;

public class PacketDispatcher {
    private static final Class playerInstanceClass;
    private static final Method getOrCreateChunkWatcher;
    private static final Method sendToAllPlayersWatchingChunk;

    public static void sendToServer(RailcraftPacket packet) {
        PacketHandler.INSTANCE.channel.sendToServer(packet.getPacket());
    }

    public static void sendToPlayer(RailcraftPacket packet, EntityPlayerMP player) {
        PacketHandler.INSTANCE.channel.sendTo(packet.getPacket(), player);
    }

    public static void sendToAll(RailcraftPacket packet) {
        PacketHandler.INSTANCE.channel.sendToAll(packet.getPacket());
    }

    public static void sendToAllAround(RailcraftPacket packet, NetworkRegistry.TargetPoint zone) {
        PacketHandler.INSTANCE.channel.sendToAllAround(packet.getPacket(), zone);
    }

    public static void sendToDimension(RailcraftPacket packet, int dimensionId) {
        PacketHandler.INSTANCE.channel.sendToDimension(packet.getPacket(), dimensionId);
    }

    public static void sendToWatchers(RailcraftPacket packet, WorldServer world, int worldX, int worldZ) {
        try {
            Object playerInstance = getOrCreateChunkWatcher.invoke((Object)world.getPlayerManager(), worldX >> 4, worldZ >> 4, false);
            if (playerInstance != null) {
                sendToAllPlayersWatchingChunk.invoke(playerInstance, packet.getPacket());
            }
        }
        catch (Exception ex) {
            Game.logThrowable("Reflection Failure in PacketDispatcher.sendToWatchers() {0} {1}", 20, ex, getOrCreateChunkWatcher.getName(), sendToAllPlayersWatchingChunk.getName());
            throw new RuntimeException(ex);
        }
    }

    static {
        try {
            playerInstanceClass = PlayerManager.class.getDeclaredClasses()[0];
            getOrCreateChunkWatcher = ReflectionHelper.findMethod(PlayerManager.class, null, (String[])new String[]{"func_72690_a", "getOrCreateChunkWatcher"}, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Boolean.TYPE});
            sendToAllPlayersWatchingChunk = ReflectionHelper.findMethod((Class)playerInstanceClass, null, (String[])new String[]{"func_151251_a", "sendToAllPlayersWatchingChunk"}, (Class[])new Class[]{Packet.class});
            getOrCreateChunkWatcher.setAccessible(true);
            sendToAllPlayersWatchingChunk.setAccessible(true);
        }
        catch (Exception ex) {
            Game.logThrowable("Reflection Failure in PacketDispatcher initalization {0} {1}", ex, new Object[0]);
            throw new RuntimeException(ex);
        }
    }
}

