/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketGuiInteger
extends RailcraftPacket {
    private int windowId;
    private int dataId;
    private int value;

    public PacketGuiInteger() {
    }

    public PacketGuiInteger(int windowId, int dataId, int value) {
        this.windowId = windowId;
        this.dataId = dataId;
        this.value = value;
    }

    public void sendPacket(EntityPlayerMP player) {
        PacketDispatcher.sendToPlayer(this, player);
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeByte(this.windowId);
        data.writeByte(this.dataId);
        data.writeInt(this.value);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.windowId = data.readByte();
        this.dataId = data.readByte();
        this.value = data.readInt();
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().thePlayer;
        if (player.openContainer != null && player.openContainer.windowId == this.windowId) {
            player.openContainer.updateProgressBar(this.dataId, this.value);
        }
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.GUI_INTEGER.ordinal();
    }
}

