/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import mods.railcraft.common.util.network.PacketDispatcher;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PacketGuiReturn
extends RailcraftPacket {
    private EntityPlayer sender;
    private IGuiReturnHandler obj;
    private byte[] extraData;

    public PacketGuiReturn(EntityPlayer sender) {
        this.sender = sender;
    }

    public PacketGuiReturn(IGuiReturnHandler obj) {
        this.obj = obj;
    }

    public PacketGuiReturn(IGuiReturnHandler obj, byte[] extraData) {
        this.obj = obj;
        this.extraData = extraData;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.obj.getWorld().provider.dimensionId);
        if (this.obj instanceof TileEntity) {
            TileEntity tile = (TileEntity)this.obj;
            data.writeBoolean(true);
            data.writeInt(tile.xCoord);
            data.writeInt(tile.yCoord);
            data.writeInt(tile.zCoord);
        } else if (this.obj instanceof Entity) {
            Entity entity = (Entity)this.obj;
            data.writeBoolean(false);
            data.writeInt(entity.getEntityId());
        } else {
            return;
        }
        this.obj.writeGuiData(data);
        if (this.extraData != null) {
            data.write(this.extraData);
        }
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        int dim = data.readInt();
        WorldServer world = DimensionManager.getWorld((int)dim);
        boolean tileReturn = data.readBoolean();
        if (tileReturn) {
            int z;
            int y;
            int x = data.readInt();
            TileEntity t = world.getTileEntity(x, y = data.readInt(), z = data.readInt());
            if (t instanceof IGuiReturnHandler) {
                ((IGuiReturnHandler)t).readGuiData(data, this.sender);
            }
        } else {
            int entityId = data.readInt();
            Entity entity = world.getEntityByID(entityId);
            if (entity instanceof IGuiReturnHandler) {
                ((IGuiReturnHandler)entity).readGuiData(data, this.sender);
            }
        }
    }

    public void sendPacket() {
        PacketDispatcher.sendToServer(this);
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.GUI_RETURN.ordinal();
    }
}

