/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.client.entity.EntityClientPlayerMP;

public class PacketGuiWidget
extends RailcraftPacket {
    private byte windowId;
    private byte widgetId;
    private byte[] payload;

    public PacketGuiWidget() {
    }

    public PacketGuiWidget(int windowId, int widgetId, byte[] data) {
        this.windowId = (byte)windowId;
        this.widgetId = (byte)widgetId;
        this.payload = data;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeByte(this.windowId);
        data.writeByte(this.widgetId);
        data.write(this.payload);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.windowId = data.readByte();
        this.widgetId = data.readByte();
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().thePlayer;
        if (player.openContainer instanceof RailcraftContainer && player.openContainer.windowId == this.windowId) {
            ((RailcraftContainer)player.openContainer).handleWidgetClientData(this.widgetId, data);
        }
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.GUI_WIDGET.ordinal();
    }
}

