/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import java.util.List;
import java.util.Random;
import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteamHobby;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class ComponentWorkshop
extends StructureVillagePieces.Village {
    private int averageGroundLevel = -1;
    private boolean hasMadeChest;

    public ComponentWorkshop() {
    }

    public ComponentWorkshop(StructureVillagePieces.Start villagePiece, int par2, Random par3Random, StructureBoundingBox sbb, int coordBaseMode) {
        this.coordBaseMode = coordBaseMode;
        this.boundingBox = sbb;
    }

    public static ComponentWorkshop buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, int coordBaseMode, int p5) {
        StructureBoundingBox box = StructureBoundingBox.getComponentToAddBoundingBox((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)11, (int)6, (int)11, (int)coordBaseMode);
        return ComponentWorkshop.canVillageGoDeeper((StructureBoundingBox)box) && StructureComponent.findIntersecting((List)pieces, (StructureBoundingBox)box) == null ? new ComponentWorkshop(villagePiece, p5, random, box, coordBaseMode) : null;
    }

    public boolean addComponentParts(World world, Random random, StructureBoundingBox sbb) {
        int l;
        int k;
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.getAverageGroundLevel(world, sbb);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.boundingBox.offset(0, this.averageGroundLevel - this.boundingBox.maxY + 4, 0);
        }
        int x = this.boundingBox.minX;
        int y = this.boundingBox.minY;
        int z = this.boundingBox.minZ;
        this.fillWithBlocks(world, sbb, 1, 1, 2, 3, 3, 4, Blocks.air, Blocks.air, false);
        this.fillWithBlocks(world, sbb, 5, 1, 0, 9, 4, 10, Blocks.air, Blocks.air, false);
        this.fillWithBlocks(world, sbb, 4, 0, 0, 10, 0, 10, (Block)Blocks.double_stone_slab, (Block)Blocks.double_stone_slab, false);
        this.fillWithBlocks(world, sbb, 0, 0, 1, 3, 0, 5, (Block)Blocks.double_stone_slab, (Block)Blocks.double_stone_slab, false);
        this.fillWithBlocks(world, sbb, 7, 1, 2, 7, 1, 8, Blocks.rail, Blocks.rail, false);
        this.placeTrack(EnumTrack.BUFFER_STOP, world, 7, 1, 1, sbb, EnumTrackMeta.NORTH_SOUTH.ordinal(), false);
        this.placeTrack(EnumTrack.BUFFER_STOP, world, 7, 1, 9, sbb, EnumTrackMeta.NORTH_SOUTH.ordinal(), true);
        this.fillWithBlocks(world, sbb, 4, 0, 0, 4, 3, 10, Blocks.brick_block, Blocks.brick_block, false);
        this.fillWithBlocks(world, sbb, 10, 0, 0, 10, 3, 10, Blocks.brick_block, Blocks.brick_block, false);
        this.fillWithBlocks(world, sbb, 5, 0, 0, 5, 4, 0, Blocks.brick_block, Blocks.brick_block, false);
        this.fillWithBlocks(world, sbb, 9, 0, 0, 9, 4, 0, Blocks.brick_block, Blocks.brick_block, false);
        this.fillWithBlocks(world, sbb, 5, 0, 10, 5, 4, 10, Blocks.brick_block, Blocks.brick_block, false);
        this.fillWithBlocks(world, sbb, 9, 0, 10, 9, 4, 10, Blocks.brick_block, Blocks.brick_block, false);
        int metaRoofSupportA = this.getMetadataWithOffset(Blocks.stone_stairs, 1) | 4;
        int metaRoofSupportB = this.getMetadataWithOffset(Blocks.stone_stairs, 0) | 4;
        for (int rz = 1; rz <= 9; ++rz) {
            this.placeBlockAtCurrentPosition(world, Blocks.brick_stairs, metaRoofSupportA, 5, 4, rz, sbb);
            this.placeBlockAtCurrentPosition(world, Blocks.brick_stairs, metaRoofSupportB, 9, 4, rz, sbb);
        }
        this.placeBlockAtCurrentPosition(world, Blocks.brick_stairs, metaRoofSupportA, 6, 4, 0, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.brick_stairs, metaRoofSupportB, 8, 4, 0, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.brick_stairs, metaRoofSupportA, 6, 4, 10, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.brick_stairs, metaRoofSupportB, 8, 4, 10, sbb);
        this.fillWithBlocks(world, sbb, 10, 2, 2, 10, 2, 3, Blocks.glass_pane, Blocks.glass_pane, false);
        this.fillWithBlocks(world, sbb, 10, 2, 7, 10, 2, 8, Blocks.glass_pane, Blocks.glass_pane, false);
        this.fillWithBlocks(world, sbb, 4, 2, 7, 4, 2, 8, Blocks.glass_pane, Blocks.glass_pane, false);
        int metaHallRoofA = this.getMetadataWithOffset(Blocks.stone_stairs, 0);
        int metaHallRoofB = this.getMetadataWithOffset(Blocks.stone_stairs, 1);
        for (int rz = 0; rz <= 10; ++rz) {
            this.placeBlockAtCurrentPosition(world, Blocks.stone_brick_stairs, metaHallRoofA, 4, 4, rz, sbb);
            this.placeBlockAtCurrentPosition(world, Blocks.stone_brick_stairs, metaHallRoofB, 10, 4, rz, sbb);
            this.placeBlockAtCurrentPosition(world, Blocks.stone_brick_stairs, metaHallRoofA, 5, 5, rz, sbb);
            this.placeBlockAtCurrentPosition(world, Blocks.stone_brick_stairs, metaHallRoofB, 9, 5, rz, sbb);
        }
        this.fillWithBlocks(world, sbb, 6, 5, 0, 8, 5, 10, Blocks.stonebrick, Blocks.stonebrick, false);
        this.fillWithMetadataBlocks(world, sbb, 6, 5, 1, 8, 5, 9, Blocks.stonebrick, 2, Blocks.stonebrick, 2, false);
        this.fillWithMetadataBlocks(world, sbb, 7, 5, 2, 7, 5, 8, Blocks.stonebrick, 1, Blocks.stonebrick, 1, false);
        this.placeBlockAtCurrentPosition(world, (Block)Blocks.stained_glass, 9, 7, 5, 2, sbb);
        this.placeBlockAtCurrentPosition(world, (Block)Blocks.stained_glass, 9, 7, 5, 5, sbb);
        this.placeBlockAtCurrentPosition(world, (Block)Blocks.stained_glass, 9, 7, 5, 8, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.torch, 0, 9, 3, 1, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.torch, 0, 9, 3, 5, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.torch, 0, 9, 3, 9, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.torch, 0, 5, 3, 1, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.torch, 0, 5, 3, 5, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.torch, 0, 5, 3, 9, sbb);
        this.fillWithBlocks(world, sbb, 0, 0, 1, 0, 3, 5, Blocks.brick_block, Blocks.brick_block, false);
        this.fillWithBlocks(world, sbb, 1, 0, 1, 3, 3, 1, Blocks.brick_block, Blocks.brick_block, false);
        this.fillWithBlocks(world, sbb, 1, 0, 5, 3, 3, 5, Blocks.brick_block, Blocks.brick_block, false);
        this.fillWithBlocks(world, sbb, 1, 4, 2, 4, 4, 4, Blocks.stonebrick, Blocks.stonebrick, false);
        int metaHutRoofA = this.getMetadataWithOffset(Blocks.stone_stairs, 0);
        for (int rz = 1; rz <= 5; ++rz) {
            this.placeBlockAtCurrentPosition(world, Blocks.stone_brick_stairs, metaHutRoofA, 0, 4, rz, sbb);
        }
        int metaHutRoofB = this.getMetadataWithOffset(Blocks.stone_stairs, 3);
        int metaHutRoofC = this.getMetadataWithOffset(Blocks.stone_stairs, 2);
        for (int rx = 1; rx <= 3; ++rx) {
            this.placeBlockAtCurrentPosition(world, Blocks.stone_brick_stairs, metaHutRoofB, rx, 4, 1, sbb);
            this.placeBlockAtCurrentPosition(world, Blocks.stone_brick_stairs, metaHutRoofC, rx, 4, 5, sbb);
        }
        this.fillWithBlocks(world, sbb, 4, 1, 3, 4, 2, 3, Blocks.air, Blocks.air, false);
        this.fillWithBlocks(world, sbb, 4, 1, 3, 4, 2, 3, Blocks.air, Blocks.air, false);
        this.placeBlockAtCurrentPosition(world, (Block)Blocks.double_stone_slab, 0, 4, 0, 3, sbb);
        this.placeDoorAtCurrentPosition(world, this.boundingBox, random, 4, 1, 3, 2);
        this.fillWithBlocks(world, sbb, 2, 2, 1, 2, 2, 1, Blocks.glass_pane, Blocks.glass_pane, false);
        this.fillWithBlocks(world, sbb, 2, 2, 5, 2, 2, 5, Blocks.glass_pane, Blocks.glass_pane, false);
        this.fillWithBlocks(world, sbb, 0, 2, 3, 0, 2, 3, Blocks.glass_pane, Blocks.glass_pane, false);
        this.placeBlockAtCurrentPosition(world, Blocks.torch, 0, 2, 3, 2, sbb);
        this.placeBlockAtCurrentPosition(world, Blocks.torch, 0, 2, 3, 4, sbb);
        if (EnumMachineAlpha.ROLLING_MACHINE.isAvaliable()) {
            this.placeBlockAtCurrentPosition(world, RailcraftBlocks.getBlockMachineAlpha(), EnumMachineAlpha.ROLLING_MACHINE.ordinal(), 9, 1, 5, sbb);
            if (EnumMachineBeta.ENGINE_STEAM_HOBBY.isAvaliable() && RailcraftConfig.machinesRequirePower()) {
                this.placeEngine(world, 9, 1, 6, sbb);
            }
        }
        for (k = 0; k < 11; ++k) {
            for (l = 4; l < 11; ++l) {
                this.clearCurrentPositionBlocksUpwards(world, l, 6, k, sbb);
                this.func_151554_b(world, Blocks.cobblestone, 0, l, -1, k, sbb);
            }
        }
        for (k = 1; k < 6; ++k) {
            for (l = 0; l < 4; ++l) {
                this.clearCurrentPositionBlocksUpwards(world, l, 6, k, sbb);
                this.func_151554_b(world, Blocks.cobblestone, 0, l, -1, k, sbb);
            }
        }
        this.placeChest(world, 9, 1, 4, 3, random, sbb);
        this.spawnVillagers(world, sbb, 0, 0, 0, 2);
        return true;
    }

    protected int getVillagerType(int par1) {
        return 456;
    }

    private void placeTrack(EnumTrack track, World world, int x, int y, int z, StructureBoundingBox sbb, int meta, boolean reversed) {
        int zz;
        int yy;
        if (!track.isEnabled()) {
            this.placeBlockAtCurrentPosition(world, Blocks.rail, 0, x, y, z, sbb);
            return;
        }
        int xx = this.getXWithOffset(x, z);
        if (!sbb.isVecInside(xx, yy = this.getYWithOffset(y), zz = this.getZWithOffset(x, z))) {
            return;
        }
        TileTrack tile = TrackTools.placeTrack(track.getTrackSpec(), world, xx, yy, zz, meta);
        boolean r = false;
        switch (this.coordBaseMode) {
            case 0: 
            case 1: {
                r = false;
                break;
            }
            case 2: 
            case 3: {
                r = true;
            }
        }
        ((ITrackReversable)tile.getTrackInstance()).setReversed(r != reversed);
    }

    private void placeEngine(World world, int x, int y, int z, StructureBoundingBox sbb) {
        int zz;
        int yy;
        int xx = this.getXWithOffset(x, z);
        if (!sbb.isVecInside(xx, yy = this.getYWithOffset(y), zz = this.getZWithOffset(x, z))) {
            return;
        }
        WorldPlugin.setBlock(world, xx, yy, zz, RailcraftBlocks.getBlockMachineBeta(), EnumMachineBeta.ENGINE_STEAM_HOBBY.ordinal());
        TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, xx, yy, zz);
        if (tile instanceof TileEngineSteamHobby) {
            TileEngineSteamHobby engine = (TileEngineSteamHobby)tile;
            engine.switchOrientation();
            engine.fill(ForgeDirection.UP, Fluids.WATER.getB(4), true);
        }
    }

    protected void func_143012_a(NBTTagCompound nbt) {
        super.func_143012_a(nbt);
        nbt.setBoolean("Chest", this.hasMadeChest);
    }

    protected void func_143011_b(NBTTagCompound nbt) {
        super.func_143011_b(nbt);
        this.hasMadeChest = nbt.getBoolean("Chest");
    }

    private void placeChest(World world, int x, int y, int z, int meta, Random rand, StructureBoundingBox sbb) {
        int xx = this.getXWithOffset(x, z);
        int yy = this.getYWithOffset(y);
        int zz = this.getZWithOffset(x, z);
        if (!this.hasMadeChest && sbb.isVecInside(xx, yy, zz)) {
            this.hasMadeChest = true;
            if (world.getBlock(xx, yy, zz) != Blocks.chest) {
                world.setBlock(xx, yy, zz, (Block)Blocks.chest, this.getMetadataWithOffset((Block)Blocks.chest, meta), 2);
                TileEntityChest chest = (TileEntityChest)world.getTileEntity(xx, yy, zz);
                if (chest != null) {
                    WeightedRandomChestContent.generateChestContents((Random)rand, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)"railcraft:workshop", (Random)rand), (IInventory)chest, (int)ChestGenHooks.getCount((String)"railcraft:workshop", (Random)rand));
                }
            }
        }
    }
}

