/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Locale;
import java.util.Random;
import mods.railcraft.common.blocks.aesthetics.cube.BlockCube;
import mods.railcraft.common.blocks.aesthetics.cube.EnumCube;
import mods.railcraft.common.worldgen.WorldGenGeode;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class GeodePopulator {
    public static final PopulateChunkEvent.Populate.EventType EVENT_TYPE = (PopulateChunkEvent.Populate.EventType)EnumHelper.addEnum(PopulateChunkEvent.Populate.EventType.class, (String)"RAILCRAFT_GEODE", (Class[])new Class[0], (Object[])new Object[0]);
    public static final int MIN_DEPTH = 16;
    public static final int MIN_FLOOR = 24;
    private static GeodePopulator instance;
    private final WorldGenerator geode = new WorldGenGeode(BlockCube.getBlock(), EnumCube.ABYSSAL_STONE.ordinal());

    private GeodePopulator() {
    }

    public static GeodePopulator instance() {
        if (instance == null) {
            instance = new GeodePopulator();
        }
        return instance;
    }

    @SubscribeEvent
    public void generate(PopulateChunkEvent.Pre event) {
        if (!TerrainGen.populate((IChunkProvider)event.chunkProvider, (World)event.world, (Random)event.rand, (int)event.chunkX, (int)event.chunkZ, (boolean)event.hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)EVENT_TYPE)) {
            return;
        }
        this.generateGeode(event.world, event.rand, event.chunkX, event.chunkZ);
    }

    public void generateGeode(World world, Random rand, int chunkX, int chunkZ) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        if (this.canGen(world, rand, x, z)) {
            OceanFloor floor = this.scanOceanFloor(world, x, z);
            if (floor.depth >= 16 && floor.floorY >= 24) {
                int y = 12 + rand.nextInt(floor.floorY - 12);
                this.geode.generate(world, rand, x, y, z);
            }
        }
    }

    private boolean canGen(World world, Random rand, int x, int z) {
        BiomeGenBase biome = world.getBiomeGenForCoords(x, z);
        if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
            return false;
        }
        if (biome.biomeName == null || biome.biomeName.toLowerCase(Locale.ENGLISH).contains("river")) {
            return false;
        }
        return rand.nextDouble() <= 0.3;
    }

    private OceanFloor scanOceanFloor(World world, int x, int z) {
        int y;
        Chunk chunk = world.getChunkFromBlockCoords(x, z);
        int trimmedX = x & 0xF;
        int trimmedZ = z & 0xF;
        int depth = 0;
        for (y = chunk.getTopFilledSegment() + 15; y > 0; --y) {
            Block block = chunk.getBlock(trimmedX, y, trimmedZ);
            if (block == null || block == Blocks.air) continue;
            if (block.getMaterial() != Material.water) break;
            ++depth;
        }
        return new OceanFloor(y, depth);
    }

    private class OceanFloor {
        public final int floorY;
        public final int depth;

        public OceanFloor(int floorY, int depth) {
            this.floorY = floorY;
            this.depth = depth;
        }
    }
}

