/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import java.util.Random;
import mods.railcraft.common.blocks.ore.BlockOre;
import mods.railcraft.common.blocks.ore.BlockWorldLogic;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.worldgen.SimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSaltpeter
extends WorldGenerator {
    private final Block minableBlock = BlockOre.getBlock();
    private final int minableBlockMeta = EnumOre.SALTPETER.ordinal();

    public boolean generate(World world, Random rand, int x, int y, int z) {
        if (this.isReplaceable(world, rand, x, y, z)) {
            world.setBlock(x, y, z, this.minableBlock, this.minableBlockMeta, 2);
            BlockWorldLogic worldLogic = BlockWorldLogic.getBlock();
            if (worldLogic != null) {
                world.setBlock(x, 0, z, (Block)worldLogic, 0, 2);
            }
        }
        return true;
    }

    private boolean isReplaceable(World world, Random rand, int x, int y, int z) {
        Block block = WorldPlugin.getBlock((IBlockAccess)world, x, y, z);
        if (block != Blocks.sand) {
            return false;
        }
        return !(SimplexNoise.noise((double)x * 0.01, (double)z * 0.01) < 0.75);
    }
}

