/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import java.util.Random;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenSmallDeposits
extends WorldGenerator {
    private final Block ore;
    private final Block replace;
    private final int meta;
    private final int number;

    public WorldGenSmallDeposits(Block ore, int meta, int number, Block replace) {
        this.ore = ore;
        this.meta = meta;
        this.number = number;
        this.replace = replace;
    }

    public boolean generate(World world, Random rand, int x, int y, int z) {
        if (this.canGen(world, x, y, z)) {
            this.placeOre(world, rand, x, y, z);
            return true;
        }
        return false;
    }

    protected boolean canGen(World world, int x, int y, int z) {
        return true;
    }

    private void placeOre(World world, Random rand, int x, int y, int z) {
        for (int num = 0; num < this.number; ++num) {
            ForgeDirection dir;
            Block block = WorldPlugin.getBlock((IBlockAccess)world, x, y, z);
            if (block != null && block.isReplaceableOreGen(world, x, y, z, this.replace)) {
                world.setBlock(x, y, z, this.ore, this.meta, 2);
            }
            if (!world.blockExists(x = MiscTools.getXOnSide(x, dir = ForgeDirection.getOrientation((int)rand.nextInt(6))), y = MiscTools.getYOnSide(y, dir), z = MiscTools.getZOnSide(z, dir))) break;
        }
    }
}

