/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import mods.railcraft.common.blocks.ore.BlockOre;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.worldgen.WorldGenSmallDeposits;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenSulfur
extends WorldGenSmallDeposits {
    private static final int AMOUNT = 10;

    public WorldGenSulfur() {
        super(BlockOre.getBlock(), EnumOre.SULFUR.ordinal(), 10, Blocks.stone);
    }

    @Override
    protected boolean canGen(World world, int x, int y, int z) {
        for (int side = 2; side < 6; ++side) {
            Block block;
            int k;
            int j;
            ForgeDirection s = ForgeDirection.getOrientation((int)side);
            int i = MiscTools.getXOnSide(x, s);
            if (!world.blockExists(i, j = MiscTools.getYOnSide(y, s), k = MiscTools.getZOnSide(z, s)) || (block = WorldPlugin.getBlock((IBlockAccess)world, i, j, k)) != Blocks.lava && block != Blocks.flowing_lava) continue;
            return true;
        }
        for (int j = 0; j < 4; ++j) {
            Block block = WorldPlugin.getBlock((IBlockAccess)world, x, y - j, z);
            if (block == Blocks.lava || block == Blocks.flowing_lava) {
                return true;
            }
            if (block == Blocks.air) continue;
            return false;
        }
        return false;
    }
}

