/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.gui;

import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.renderer.StorageRenderItem;
import com.jaquadro.minecraft.storagedrawers.integration.IntegrationRegistry;
import com.jaquadro.minecraft.storagedrawers.integration.NotEnoughItems;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers1;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers2;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers4;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawersComp;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotStorage;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotUpgrade;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiDrawers
extends GuiContainer {
    private static final ResourceLocation guiTextures1 = new ResourceLocation("storagedrawers", "textures/gui/drawers_1.png");
    private static final ResourceLocation guiTextures2 = new ResourceLocation("storagedrawers", "textures/gui/drawers_2.png");
    private static final ResourceLocation guiTextures4 = new ResourceLocation("storagedrawers", "textures/gui/drawers_4.png");
    private static final ResourceLocation guiTexturesComp = new ResourceLocation("storagedrawers", "textures/gui/drawers_comp.png");
    private static final int smDisabledX = 176;
    private static final int smDisabledY = 0;
    private static final Object[] empty = new Object[0];
    private static StorageRenderItem storageItemRender = new StorageRenderItem();
    private TileEntityDrawers tileDrawers;

    public GuiDrawers(InventoryPlayer inventory, TileEntityDrawers tileEntity) {
        super(GuiDrawers.getContainer(inventory, tileEntity));
        this.tileDrawers = tileEntity;
        this.xSize = 176;
        this.ySize = 199;
        itemRender = storageItemRender;
    }

    private static Container getContainer(InventoryPlayer inventory, TileEntityDrawers tile) {
        switch (tile.getDrawerCount()) {
            case 1: {
                return new ContainerDrawers1(inventory, tile);
            }
            case 2: {
                return new ContainerDrawers2(inventory, tile);
            }
            case 3: {
                return new ContainerDrawersComp(inventory, tile);
            }
            case 4: {
                return new ContainerDrawers4(inventory, tile);
            }
        }
        return null;
    }

    public void drawScreen(int p_73863_1_, int p_73863_2_, float p_73863_3_) {
        RenderItem ri = this.setItemRender(storageItemRender);
        if (this.inventorySlots instanceof ContainerDrawers) {
            ((ContainerDrawers)this.inventorySlots).getStorageInventory().activeRenderItem = storageItemRender;
        }
        super.drawScreen(p_73863_1_, p_73863_2_, p_73863_3_);
        if (this.inventorySlots instanceof ContainerDrawers) {
            ((ContainerDrawers)this.inventorySlots).getStorageInventory().activeRenderItem = null;
            GuiDrawers.storageItemRender.overrideStack = null;
        }
        this.setItemRender(ri);
    }

    protected void drawGuiContainerForegroundLayer(int p_146979_1_, int p_146979_2_) {
        String name = this.tileDrawers.hasCustomInventoryName() ? this.tileDrawers.getInventoryName() : I18n.format((String)this.tileDrawers.getInventoryName(), (Object[])empty);
        this.fontRendererObj.drawString(name, 8, 6, 0x404040);
        this.fontRendererObj.drawString(I18n.format((String)"storageDrawers.container.upgrades", (Object[])empty), 8, 75, 0x404040);
        this.fontRendererObj.drawString(I18n.format((String)"container.inventory", (Object[])empty), 8, this.ySize - 96 + 2, 0x404040);
    }

    protected void drawGuiContainerBackgroundLayer(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tileDrawers.getDrawerCount() == 1) {
            this.mc.getTextureManager().bindTexture(guiTextures1);
        } else if (this.tileDrawers.getDrawerCount() == 2) {
            this.mc.getTextureManager().bindTexture(guiTextures2);
        } else if (this.tileDrawers.getDrawerCount() == 4) {
            this.mc.getTextureManager().bindTexture(guiTextures4);
        } else {
            this.mc.getTextureManager().bindTexture(guiTexturesComp);
        }
        int guiX = (this.width - this.xSize) / 2;
        int guiY = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(guiX, guiY, 0, 0, this.xSize, this.ySize);
        if (this.inventorySlots instanceof ContainerDrawers) {
            ContainerDrawers container = (ContainerDrawers)this.inventorySlots;
            List<Slot> storageSlots = container.getStorageSlots();
            int n = storageSlots.size();
            for (int i = 0; i < n; ++i) {
                Slot slot = storageSlots.get(i);
                this.drawTexturedModalRect(guiX + slot.xDisplayPosition, guiY + slot.yDisplayPosition, 176, 0, 16, 16);
            }
            List<Slot> upgradeSlots = container.getUpgradeSlots();
            int n2 = upgradeSlots.size();
            for (int i = 0; i < n2; ++i) {
                Slot slot = upgradeSlots.get(i);
                if (!(slot instanceof SlotUpgrade) || ((SlotUpgrade)slot).canTakeStack()) continue;
                this.drawTexturedModalRect(guiX + slot.xDisplayPosition, guiY + slot.yDisplayPosition, 176, 0, 16, 16);
            }
        }
    }

    protected boolean func_146978_c(int x, int y, int width, int height, int originX, int originY) {
        if (this.inventorySlots instanceof ContainerDrawers) {
            ContainerDrawers container = (ContainerDrawers)this.inventorySlots;
            List<Slot> storageSlots = container.getStorageSlots();
            int n = storageSlots.size();
            for (int i = 0; i < n; ++i) {
                Slot slot = storageSlots.get(i);
                if (!(slot instanceof SlotStorage) || slot.xDisplayPosition != x || slot.yDisplayPosition != y) continue;
                return false;
            }
            List<Slot> upgradeSlots = container.getUpgradeSlots();
            int n2 = upgradeSlots.size();
            for (int i = 0; i < n2; ++i) {
                Slot slot = upgradeSlots.get(i);
                if (!(slot instanceof SlotUpgrade) || ((SlotUpgrade)slot).canTakeStack() || slot.xDisplayPosition != x || slot.yDisplayPosition != y) continue;
                return false;
            }
        }
        return super.func_146978_c(x, y, width, height, originX, originY);
    }

    private RenderItem setItemRender(RenderItem renderItem) {
        if (IntegrationRegistry.instance().isModLoaded("NotEnoughItems")) {
            return NotEnoughItems.setItemRender(renderItem);
        }
        RenderItem prev = itemRender;
        itemRender = renderItem;
        return prev;
    }
}

