/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.client.renderer.ModularBoxRenderer;
import com.jaquadro.minecraft.storagedrawers.client.renderer.common.CommonDrawerRenderer;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelper;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelperState;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class DrawersItemRenderer
implements IItemRenderer {
    private CommonDrawerRenderer commonRender = new CommonDrawerRenderer();
    private ModularBoxRenderer boxRenderer = new ModularBoxRenderer();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        RenderBlocks renderer = this.getRenderer(data);
        if (renderer == null) {
            return;
        }
        Block block = Block.getBlockFromItem((Item)item.getItem());
        if (!(block instanceof BlockDrawers)) {
            return;
        }
        this.renderDrawer((BlockDrawers)block, item, renderer, type);
    }

    private void renderDrawer(BlockDrawers block, ItemStack item, RenderBlocks renderer, IItemRenderer.ItemRenderType renderType) {
        int side = 4;
        if (renderType == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (renderType == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (renderType == IItemRenderer.ItemRenderType.INVENTORY || renderType == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glTranslatef((float)(block.halfDepth ? -0.75f : -0.5f), (float)-0.5f, (float)-0.5f);
        }
        if (block instanceof BlockDrawersCustom) {
            this.renderCustomBlock(block, item, renderer);
        } else {
            this.renderBaseBlock(block, item, renderer);
        }
        if (item.hasTagCompound() && item.getTagCompound().hasKey("tile")) {
            double depth = block.halfDepth ? 0.5 : 1.0;
            RenderHelper.instance.setRenderBounds(1.0 - depth - 0.005, 0.0, 0.0, 1.0, 1.0, 1.0);
            RenderHelper.instance.renderFace(side, null, (Block)block, block.getTapeIcon(), 1.0f, 1.0f, 1.0f);
        }
        if (renderType == IItemRenderer.ItemRenderType.INVENTORY || renderType == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glTranslatef((float)(block.halfDepth ? 0.75f : 0.5f), (float)0.5f, (float)0.5f);
        }
    }

    private void renderBaseBlock(BlockDrawers block, ItemStack item, RenderBlocks renderer) {
        int side = 4;
        RenderHelper.instance.state.setUVRotation(1, RenderHelperState.ROTATION_BY_FACE_FACE[3][side]);
        this.boxRenderer.setUnit(block.getTrimWidth());
        this.boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        for (int i = 0; i < 6; ++i) {
            this.boxRenderer.setIcon(block.getIcon(i, item.getItemDamage()), i);
        }
        this.renderExterior(block, 0, 0, 0, side, renderer);
        RenderHelper.instance.state.clearUVRotation(1);
        this.boxRenderer.setUnit(0.0);
        this.boxRenderer.setInteriorIcon(block.getIcon(side, item.getItemDamage()), ForgeDirection.OPPOSITES[side]);
        this.renderInterior(block, 0, 0, 0, side, renderer);
    }

    private void renderCustomBlock(BlockDrawers block, ItemStack item, RenderBlocks renderer) {
        BlockDrawersCustom custom = (BlockDrawersCustom)block;
        ItemStack materialSide = null;
        ItemStack materialTrim = null;
        ItemStack materialFront = null;
        if (item.hasTagCompound()) {
            NBTTagCompound tag = item.getTagCompound();
            if (tag.hasKey("MatS")) {
                materialSide = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag.getCompoundTag("MatS"));
            }
            if (tag.hasKey("MatT")) {
                materialTrim = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag.getCompoundTag("MatT"));
            }
            if (tag.hasKey("MatF")) {
                materialFront = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag.getCompoundTag("MatF"));
            }
        }
        if (materialSide == null) {
            materialSide = new ItemStack((Block)block);
        }
        if (materialTrim == null) {
            materialTrim = materialSide;
        }
        if (materialFront == null) {
            materialFront = materialSide;
        }
        IIcon trimIcon = Block.getBlockFromItem((Item)materialTrim.getItem()).getIcon(4, materialTrim.getItemDamage());
        IIcon panelIcon = Block.getBlockFromItem((Item)materialSide.getItem()).getIcon(4, materialSide.getItemDamage());
        IIcon frontIcon = Block.getBlockFromItem((Item)materialFront.getItem()).getIcon(4, materialFront.getItemDamage());
        if (trimIcon == null) {
            trimIcon = custom.getDefaultTrimIcon();
        }
        if (panelIcon == null) {
            panelIcon = custom.getDefaultFaceIcon();
        }
        if (frontIcon == null) {
            frontIcon = custom.getDefaultFaceIcon();
        }
        this.commonRender.renderBasePass(null, 0, 0, 0, custom, 4, panelIcon, trimIcon, frontIcon);
        this.commonRender.renderOverlayPass(null, 0, 0, 0, custom, 4, trimIcon, frontIcon);
    }

    private void renderExterior(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer) {
        double depth = block.halfDepth ? 0.5 : 1.0;
        double xMin = 0.0;
        double xMax = 0.0;
        double zMin = 0.0;
        double zMax = 0.0;
        switch (side) {
            case 2: {
                xMin = 0.0;
                xMax = 1.0;
                zMin = 1.0 - depth;
                zMax = 1.0;
                break;
            }
            case 3: {
                xMin = 0.0;
                xMax = 1.0;
                zMin = 0.0;
                zMax = depth;
                break;
            }
            case 4: {
                xMin = 1.0 - depth;
                xMax = 1.0;
                zMin = 0.0;
                zMax = 1.0;
                break;
            }
            case 5: {
                xMin = 0.0;
                xMax = depth;
                zMin = 0.0;
                zMax = 1.0;
            }
        }
        this.boxRenderer.renderExterior(renderer.blockAccess, (Block)block, x, y, z, xMin, 0.0, zMin, xMax, 1.0, zMax, 0, ModularBoxRenderer.sideCut[side]);
    }

    private void renderInterior(BlockDrawers block, int x, int y, int z, int side, RenderBlocks renderer) {
        double unit = block.getTrimDepth();
        double depth = block.halfDepth ? 0.5 : 1.0;
        double xMin = 0.0;
        double xMax = 0.0;
        double zMin = 0.0;
        double zMax = 0.0;
        switch (side) {
            case 2: {
                xMin = unit;
                xMax = 1.0 - unit;
                zMin = 1.0 - depth;
                zMax = 1.0 - depth + unit;
                break;
            }
            case 3: {
                xMin = unit;
                xMax = 1.0 - unit;
                zMin = depth - unit;
                zMax = depth;
                break;
            }
            case 4: {
                xMin = 1.0 - depth;
                xMax = 1.0 - depth + unit;
                zMin = unit;
                zMax = 1.0 - unit;
                break;
            }
            case 5: {
                xMin = depth - unit;
                xMax = depth;
                zMin = unit;
                zMax = 1.0 - unit;
            }
        }
        this.boxRenderer.renderInterior(renderer.blockAccess, (Block)block, x, y, z, xMin, unit, zMin, xMax, 1.0 - unit, zMax, 0, ModularBoxRenderer.sideCut[side]);
    }

    private RenderBlocks getRenderer(Object[] data) {
        for (Object obj : data) {
            if (!(obj instanceof RenderBlocks)) continue;
            return (RenderBlocks)obj;
        }
        return null;
    }
}

