/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class StorageRenderItem
extends RenderItem {
    public ItemStack overrideStack;

    public void renderItemOverlayIntoGUI(FontRenderer font, TextureManager texManager, ItemStack item, int x, int y, String text) {
        if (item != this.overrideStack) {
            super.renderItemOverlayIntoGUI(font, texManager, item, x, y, text);
            return;
        }
        if (item != null) {
            float scale = 0.5f;
            float xoff = 0.0f;
            if (font.getUnicodeFlag()) {
                scale = 1.0f;
                xoff = 1.0f;
            }
            if (item.stackSize > 1 || text != null) {
                text = item.stackSize >= 100000000 || item.stackSize >= 1000000 && font.getUnicodeFlag() ? (text == null ? String.format("%.0fM", Float.valueOf((float)item.stackSize / 1000000.0f)) : text) : (item.stackSize >= 1000000 ? (text == null ? String.format("%.1fM", Float.valueOf((float)item.stackSize / 1000000.0f)) : text) : (item.stackSize >= 100000 || item.stackSize >= 10000 && font.getUnicodeFlag() ? (text == null ? String.format("%.0fK", Float.valueOf((float)item.stackSize / 1000.0f)) : text) : (item.stackSize >= 10000 ? (text == null ? String.format("%.1fK", Float.valueOf((float)item.stackSize / 1000.0f)) : text) : (text == null ? String.valueOf(item.stackSize) : text))));
                int textX = (int)(((float)(x + 16) + xoff - (float)font.getStringWidth(text) * scale) / scale) - 1;
                int textY = (int)(((float)(y + 16) - 7.0f * scale) / scale) - 1;
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)3042);
                GL11.glPushMatrix();
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                font.drawStringWithShadow(text, textX, textY, 0xFFFFFF);
                GL11.glPopMatrix();
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
            }
            if (item.getItem().showDurabilityBar(item)) {
                double health = item.getItem().getDurabilityForDisplay(item);
                int j1 = (int)Math.round(13.0 - health * 13.0);
                int k = (int)Math.round(255.0 - health * 255.0);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)3042);
                Tessellator tessellator = Tessellator.instance;
                int l = 255 - k << 16 | k << 8;
                int i1 = (255 - k) / 4 << 16 | 0x3F00;
                this.renderQuad(tessellator, x + 2, y + 13, 13, 2, 0);
                this.renderQuad(tessellator, x + 2, y + 13, 12, 1, i1);
                this.renderQuad(tessellator, x + 2, y + 13, j1, 1, l);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private void renderQuad(Tessellator tessellator, int x, int y, int w, int h, int color) {
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(color);
        tessellator.addVertex((double)(x + 0), (double)(y + 0), 0.0);
        tessellator.addVertex((double)(x + 0), (double)(y + h), 0.0);
        tessellator.addVertex((double)(x + w), (double)(y + h), 0.0);
        tessellator.addVertex((double)(x + w), (double)(y + 0), 0.0);
        tessellator.draw();
    }
}

