/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class CompTierRegistry {
    private List<Record> records = new ArrayList<Record>();

    public CompTierRegistry() {
        this.register(new ItemStack(Blocks.clay), new ItemStack(Items.clay_ball), 4);
        this.register(new ItemStack(Blocks.snow), new ItemStack(Items.snowball), 4);
        this.register(new ItemStack(Blocks.glowstone), new ItemStack(Items.glowstone_dust), 4);
        this.register(new ItemStack(Blocks.brick_block), new ItemStack(Items.brick), 4);
        this.register(new ItemStack(Blocks.nether_brick), new ItemStack(Items.netherbrick), 4);
        this.register(new ItemStack(Blocks.quartz_block), new ItemStack(Items.quartz), 4);
        this.register(new ItemStack(Blocks.melon_block), new ItemStack(Items.melon), 9);
        if (!Loader.isModLoaded((String)"ExtraUtilities")) {
            this.register(new ItemStack(Blocks.sandstone), new ItemStack((Block)Blocks.sand), 4);
        }
    }

    public boolean register(ItemStack upper, ItemStack lower, int convRate) {
        if (upper == null || lower == null) {
            return false;
        }
        this.unregisterUpperTarget(upper);
        this.unregisterLowerTarget(lower);
        Record r = new Record();
        r.upper = upper.copy();
        r.lower = lower.copy();
        r.convRate = convRate;
        r.upper.stackSize = 1;
        r.lower.stackSize = 1;
        this.records.add(r);
        return true;
    }

    public boolean unregisterUpperTarget(ItemStack stack) {
        for (Record r : this.records) {
            if (!ItemStack.areItemStacksEqual((ItemStack)stack, (ItemStack)r.upper)) continue;
            this.records.remove(r);
            return true;
        }
        return false;
    }

    public boolean unregisterLowerTarget(ItemStack stack) {
        for (Record r : this.records) {
            if (!ItemStack.areItemStacksEqual((ItemStack)stack, (ItemStack)r.lower)) continue;
            this.records.remove(r);
            return true;
        }
        return false;
    }

    public Record findHigherTier(ItemStack stack) {
        if (stack == null || stack.getItem() == null) {
            return null;
        }
        int n = this.records.size();
        for (int i = 0; i < n; ++i) {
            Record r = this.records.get(i);
            if (!stack.isItemEqual(r.lower) || !ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)r.lower)) continue;
            return r;
        }
        return null;
    }

    public Record findLowerTier(ItemStack stack) {
        if (stack == null || stack.getItem() == null) {
            return null;
        }
        int n = this.records.size();
        for (int i = 0; i < n; ++i) {
            Record r = this.records.get(i);
            if (!stack.isItemEqual(r.upper) || !ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)r.upper)) continue;
            return r;
        }
        return null;
    }

    public class Record {
        public ItemStack upper;
        public ItemStack lower;
        public int convRate;
    }
}

