/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core.recipe;

import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import java.util.ArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class TemplateRecipe
implements IRecipe {
    public boolean matches(InventoryCrafting inventory, World world) {
        return this.getCraftingResult(inventory) != null;
    }

    public ItemStack getCraftingResult(InventoryCrafting inventory) {
        ArrayList sticks = OreDictionary.getOres((String)"stickWood");
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                if (row == 1 && col == 1) continue;
                ItemStack stack = inventory.getStackInRowAndColumn(col, row);
                if (stack == null) {
                    return null;
                }
                boolean match = false;
                for (ItemStack comp : sticks) {
                    if (comp == null || !comp.isItemEqual(stack)) continue;
                    match = true;
                }
                if (match) continue;
                return null;
            }
        }
        ItemStack center = inventory.getStackInRowAndColumn(1, 1);
        if (center == null || !(center.getItem() instanceof ItemDrawers)) {
            return null;
        }
        if (center.getTagCompound() != null && center.getTagCompound().hasKey("tile")) {
            return null;
        }
        return this.getRecipeOutput();
    }

    public int getRecipeSize() {
        return 9;
    }

    public ItemStack getRecipeOutput() {
        return new ItemStack(ModItems.upgradeTemplate, 1);
    }
}

