/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrimCustom;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.inventory.InventoryContainerProxy;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotCraftResult;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotRestricted;
import com.jaquadro.minecraft.storagedrawers.item.ItemCustomDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemCustomTrim;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ContainerFramingTable
extends Container {
    private static final int InventoryX = 8;
    private static final int InventoryY = 84;
    private static final int HotbarY = 142;
    private static final int InputX = 23;
    private static final int InputY = 35;
    private static final int MaterialSideX = 50;
    private static final int MaterialSideY = 17;
    private static final int MaterialTrimX = 102;
    private static final int MaterialTrimY = 17;
    private static final int MaterialFrontX = 50;
    private static final int MaterialFrontY = 53;
    private static final int OutputX = 133;
    private static final int OutputY = 35;
    private IInventory tableInventory;
    private IInventory craftResult = new InventoryCraftResult();
    private Slot inputSlot;
    private Slot materialSideSlot;
    private Slot materialTrimSlot;
    private Slot materialFrontSlot;
    private Slot outputSlot;
    private List<Slot> playerSlots;
    private List<Slot> hotbarSlots;

    public ContainerFramingTable(InventoryPlayer inventory, TileEntityFramingTable tileEntity) {
        int i;
        this.tableInventory = new InventoryContainerProxy(tileEntity, this);
        this.inputSlot = this.addSlotToContainer(new SlotRestricted(this.tableInventory, 0, 23, 35));
        this.materialSideSlot = this.addSlotToContainer(new SlotRestricted(this.tableInventory, 1, 50, 17));
        this.materialTrimSlot = this.addSlotToContainer(new SlotRestricted(this.tableInventory, 2, 102, 17));
        this.materialFrontSlot = this.addSlotToContainer(new SlotRestricted(this.tableInventory, 3, 50, 53));
        this.outputSlot = this.addSlotToContainer(new SlotCraftResult(inventory.player, this.tableInventory, this.craftResult, new int[]{0, 1, 2, 3}, 4, 133, 35));
        this.playerSlots = new ArrayList<Slot>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.addSlotToContainer(new Slot((IInventory)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.addSlotToContainer(new Slot((IInventory)inventory, i, 8 + i * 18, 142)));
        }
        this.onCraftMatrixChanged(this.tableInventory);
    }

    public boolean canInteractWith(EntityPlayer player) {
        return this.tableInventory.isUseableByPlayer(player);
    }

    public void onCraftMatrixChanged(IInventory inventory) {
        ItemStack target = this.tableInventory.getStackInSlot(this.inputSlot.getSlotIndex());
        ItemStack matSide = this.tableInventory.getStackInSlot(this.materialSideSlot.getSlotIndex());
        ItemStack matTrim = this.tableInventory.getStackInSlot(this.materialTrimSlot.getSlotIndex());
        ItemStack matFront = this.tableInventory.getStackInSlot(this.materialFrontSlot.getSlotIndex());
        if (target != null) {
            Block block = Block.getBlockFromItem((Item)target.getItem());
            if (block instanceof BlockDrawersCustom) {
                if (matSide != null) {
                    this.craftResult.setInventorySlotContents(0, ItemCustomDrawers.makeItemStack(block, 1, matSide, matTrim, matFront));
                    return;
                }
            } else if (block instanceof BlockTrimCustom && matSide != null) {
                this.craftResult.setInventorySlotContents(0, ItemCustomTrim.makeItemStack(block, 1, matSide, matTrim));
                return;
            }
        }
        this.craftResult.setInventorySlotContents(0, null);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int slotIndex) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        int inventoryStart = this.playerSlots.get((int)0).slotNumber;
        int hotbarStart = this.hotbarSlots.get((int)0).slotNumber;
        int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).slotNumber + 1;
        if (slot != null && slot.getHasStack()) {
            ItemStack slotStack = slot.getStack();
            itemStack = slotStack.copy();
            if (slotIndex == this.outputSlot.slotNumber) {
                if (!this.mergeItemStack(slotStack, inventoryStart, hotbarEnd, true)) {
                    return null;
                }
                slot.onSlotChange(slotStack, itemStack);
            } else if (slotIndex >= inventoryStart && slotIndex < hotbarEnd) {
                boolean merged = false;
                if (TileEntityFramingTable.isItemValidDrawer(slotStack)) {
                    merged = this.mergeItemStack(slotStack, this.inputSlot.slotNumber, this.inputSlot.slotNumber + 1, false);
                }
                if (TileEntityFramingTable.isItemValidMaterial(slotStack)) {
                    merged = this.mergeItemStack(slotStack, this.materialSideSlot.slotNumber, this.materialFrontSlot.slotNumber + 1, false);
                }
                if (!merged && (slotIndex >= inventoryStart && slotIndex < hotbarStart ? !this.mergeItemStack(slotStack, hotbarStart, hotbarEnd, false) : slotIndex >= hotbarStart && slotIndex < hotbarEnd && !this.mergeItemStack(slotStack, inventoryStart, hotbarStart, false))) {
                    return null;
                }
            } else if (!this.mergeItemStack(slotStack, inventoryStart, hotbarEnd, false)) {
                return null;
            }
            if (slotStack.stackSize == 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
            if (slotStack.stackSize == itemStack.stackSize) {
                return null;
            }
            slot.onPickupFromSlot(player, slotStack);
        }
        return itemStack;
    }
}

