/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.network;

import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import org.apache.logging.log4j.Level;

public class CountUpdateMessage
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int slot;
    private int count;

    public CountUpdateMessage() {
    }

    public CountUpdateMessage(int x, int y, int z, int slot, int count) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.slot = slot;
        this.count = count;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readShort();
        this.z = buf.readInt();
        this.slot = buf.readByte();
        this.count = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeShort(this.y);
        buf.writeInt(this.z);
        buf.writeByte(this.slot);
        buf.writeInt(this.count);
    }

    public static class HandlerStub
    implements IMessageHandler<CountUpdateMessage, IMessage> {
        public IMessage onMessage(CountUpdateMessage message, MessageContext ctx) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.WARN, (String)"CountUpdateMessage stub handler called.", (Object[])new Object[0]);
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Handler
    implements IMessageHandler<CountUpdateMessage, IMessage> {
        public IMessage onMessage(CountUpdateMessage message, MessageContext ctx) {
            WorldClient world;
            TileEntity tileEntity;
            if (ctx.side == Side.CLIENT && (tileEntity = (world = Minecraft.getMinecraft().theWorld).getTileEntity(message.x, message.y, message.z)) instanceof TileEntityDrawers) {
                ((TileEntityDrawers)tileEntity).clientUpdateCount(message.slot, message.count);
            }
            return null;
        }
    }
}

