/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ToolCore;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;

public abstract class HarvestTool
extends ToolCore {
    public HarvestTool(int baseDamage) {
        super(baseDamage);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (stack == null || !(stack.func_77973_b() instanceof HarvestTool)) {
            return -1;
        }
        if (toolClass == null || !this.getHarvestType().equals(toolClass)) {
            return -1;
        }
        if (!stack.func_77942_o()) {
            return -1;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Broken")) {
            return 0;
        }
        return tags.func_74762_e("HarvestLevel");
    }

    @Override
    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (!stack.func_77942_o()) {
            return 1.0f;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Broken")) {
            return 0.1f;
        }
        if (this.isEffective(block, meta)) {
            return this.calculateStrength(tags, block, meta);
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public float calculateStrength(NBTTagCompound tags, Block block, int meta) {
        int hlvl = block.getHarvestLevel(meta);
        if (hlvl > tags.func_74762_e("HarvestLevel")) {
            return 0.1f;
        }
        return AbilityHelper.calcToolSpeed(this, tags);
    }

    public float breakSpeedModifier() {
        return 1.0f;
    }

    public float stoneboundModifier() {
        return 72.0f;
    }

    public boolean func_150897_b(Block block) {
        return this.isEffective(block.func_149688_o());
    }

    @Override
    public String[] getTraits() {
        return new String[]{"harvest"};
    }

    protected abstract Material[] getEffectiveMaterials();

    protected abstract String getHarvestType();

    public Set<String> getToolClasses(ItemStack stack) {
        HashSet<String> set = new HashSet<String>();
        if (stack != null && stack.func_77973_b() instanceof HarvestTool) {
            set.add(((HarvestTool)stack.func_77973_b()).getHarvestType());
        }
        return set;
    }

    public boolean isEffective(Block block, int meta) {
        if (this.getHarvestType().equals(block.getHarvestTool(meta))) {
            return true;
        }
        return this.isEffective(block.func_149688_o());
    }

    public boolean isEffective(Material material) {
        for (Material m : this.getEffectiveMaterials()) {
            if (m != material) continue;
            return true;
        }
        return false;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        Item item;
        boolean used = false;
        int hotbarSlot = player.field_71071_by.field_70461_c;
        int itemSlot = hotbarSlot == 0 ? 8 : hotbarSlot + 1;
        ItemStack nearbyStack = null;
        if (hotbarSlot < 8 && (nearbyStack = player.field_71071_by.func_70301_a(itemSlot)) != null && ((item = nearbyStack.func_77973_b()) instanceof ItemBlock || item != null && item == TinkerTools.openBlocksDevNull)) {
            Block blockToPlace;
            int posX = x;
            int posY = y;
            int posZ = z;
            switch (side) {
                case 0: {
                    --posY;
                    break;
                }
                case 1: {
                    ++posY;
                    break;
                }
                case 2: {
                    --posZ;
                    break;
                }
                case 3: {
                    ++posZ;
                    break;
                }
                case 4: {
                    --posX;
                    break;
                }
                case 5: {
                    ++posX;
                }
            }
            AxisAlignedBB blockBounds = AxisAlignedBB.func_72330_a((double)posX, (double)posY, (double)posZ, (double)(posX + 1), (double)(posY + 1), (double)(posZ + 1));
            AxisAlignedBB playerBounds = player.field_70121_D;
            if (item instanceof ItemBlock && (blockToPlace = ((ItemBlock)item).field_150939_a).func_149688_o().func_76230_c() && playerBounds.func_72326_a(blockBounds)) {
                return false;
            }
            int dmg = nearbyStack.func_77960_j();
            int count = nearbyStack.field_77994_a;
            if (item == TinkerTools.openBlocksDevNull) {
                player.field_71071_by.field_70461_c = itemSlot;
                item.func_77648_a(nearbyStack, player, world, x, y, z, side, clickX, clickY, clickZ);
                player.field_71071_by.field_70461_c = hotbarSlot;
                player.func_71038_i();
            } else {
                used = item.func_77648_a(nearbyStack, player, world, x, y, z, side, clickX, clickY, clickZ);
            }
            if (player.field_71075_bZ.field_75098_d) {
                nearbyStack.func_77964_b(dmg);
                nearbyStack.field_77994_a = count;
            }
            if (nearbyStack.field_77994_a < 1) {
                nearbyStack = null;
                player.field_71071_by.func_70299_a(itemSlot, null);
            }
        }
        return used;
    }

    public void breakExtraBlock(World world, int x, int y, int z, int sidehit, EntityPlayer playerEntity, int refX, int refY, int refZ) {
        int meta;
        if (world.func_147437_c(x, y, z)) {
            return;
        }
        if (!(playerEntity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)playerEntity;
        Block block = world.func_147439_a(x, y, z);
        if (!this.isEffective(block, meta = world.func_72805_g(x, y, z))) {
            return;
        }
        Block refBlock = world.func_147439_a(refX, refY, refZ);
        float refStrength = ForgeHooks.blockStrength((Block)refBlock, (EntityPlayer)player, (World)world, (int)refX, (int)refY, (int)refZ);
        float strength = ForgeHooks.blockStrength((Block)block, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta) || refStrength / strength > 10.0f) {
            return;
        }
        BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (int)x, (int)y, (int)z);
        if (event.isCanceled()) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, false)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if (!world.field_72995_K) {
                player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
            }
            return;
        }
        ItemStack currentItem = player.func_71045_bC();
        if (currentItem != null) {
            currentItem.func_150999_a(world, block, x, y, z, (EntityPlayer)player);
        }
        if (!world.field_72995_K) {
            block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
                block.func_149636_a(world, (EntityPlayer)player, x, y, z, meta);
                block.func_149657_c(world, x, y, z, event.getExpToDrop());
            }
            player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
        } else {
            ItemStack itemstack;
            world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if ((itemstack = player.func_71045_bC()) != null) {
                itemstack.func_150999_a(world, block, x, y, z, (EntityPlayer)player);
                if (itemstack.field_77994_a == 0) {
                    player.func_71028_bD();
                }
            }
            if (PHConstruct.extraBlockUpdates) {
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(2, x, y, z, Minecraft.func_71410_x().field_71476_x.field_72310_e));
            }
        }
    }
}

