/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.blocks.abstracts.InventoryBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.armor.modelblock.DryingRackRender;
import tconstruct.blocks.logic.DryingRackLogic;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.AbilityHelper;

public class DryingRack
extends InventoryBlock {
    public DryingRack() {
        super(Material.wood);
        this.setCreativeTab(TConstructRegistry.blockTab);
        this.setHardness(2.0f);
        this.stepSound = soundTypeMetal;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new DryingRackLogic();
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        return null;
    }

    public Object getModInstance() {
        return TConstruct.instance;
    }

    public int onBlockPlaced(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        if (side > 1) {
            return side;
        }
        return meta;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLiving living, ItemStack stack) {
        int l;
        int direction;
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 0 && (direction = (l = MathHelper.floor_double((double)((double)(living.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3) % 2) == 1) {
            world.setBlockMetadataWithNotify(x, y, z, 1, 2);
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        return this.activateDryingRack(world, x, y, z, player);
    }

    boolean activateDryingRack(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.isRemote) {
            DryingRackLogic logic = (DryingRackLogic)world.getTileEntity(x, y, z);
            if (!logic.isStackInSlot(0)) {
                ItemStack stack = player.getCurrentEquippedItem();
                if (stack != null) {
                    stack = player.inventory.decrStackSize(player.inventory.currentItem, 1);
                    logic.setInventorySlotContents(0, stack);
                }
            } else {
                ItemStack decrStack = logic.decrStackSize(0, 1);
                if (decrStack != null) {
                    AbilityHelper.spawnItemAtPlayer(player, decrStack);
                }
            }
            world.markBlockForUpdate(x, y, z);
        }
        return true;
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        int metadata = world.getBlockMetadata(x, y, z);
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        switch (metadata) {
            case 0: {
                zMin = 0.375f;
                yMax = 0.25f;
                zMax = 0.625f;
                break;
            }
            case 1: {
                xMin = 0.375f;
                yMax = 0.25f;
                xMax = 0.625f;
                break;
            }
            case 2: {
                zMin = 0.75f;
                yMin = 0.75f;
                break;
            }
            case 3: {
                zMax = 0.25f;
                yMin = 0.75f;
                break;
            }
            case 4: {
                xMin = 0.75f;
                yMin = 0.75f;
                break;
            }
            case 5: {
                xMax = 0.25f;
                yMin = 0.75f;
            }
        }
        return AxisAlignedBB.getBoundingBox((double)((double)x + (double)xMin), (double)((double)y + (double)yMin), (double)((double)z + (double)zMin), (double)((double)x + (double)xMax), (double)((double)y + (double)yMax), (double)((double)z + (double)zMax));
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        int metadata = world.getBlockMetadata(x, y, z);
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        switch (metadata) {
            case 0: {
                zMin = 0.375f;
                yMax = 0.25f;
                zMax = 0.625f;
                break;
            }
            case 1: {
                xMin = 0.375f;
                yMax = 0.25f;
                xMax = 0.625f;
                break;
            }
            case 2: {
                zMin = 0.75f;
                yMin = 0.75f;
                break;
            }
            case 3: {
                zMax = 0.25f;
                yMin = 0.75f;
                break;
            }
            case 4: {
                xMin = 0.75f;
                yMin = 0.75f;
                break;
            }
            case 5: {
                xMax = 0.25f;
                yMin = 0.75f;
            }
        }
        this.setBlockBounds(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        super.addCollisionBoxesToList(world, x, y, z, aabb, list, entity);
    }

    public int getRenderType() {
        return DryingRackRender.model;
    }

    public String[] getTextureNames() {
        String[] textureNames = new String[]{"castingtable_top", "castingtable_side", "castingtable_bottom", "faucet", "blockcast_top", "blockcast_side", "blockcast_bottom"};
        return textureNames;
    }

    public String getTextureDomain(int textureNameIndex) {
        return "tinker";
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return Blocks.planks.getIcon(side, 0);
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new DryingRackLogic();
    }
}

