/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import tconstruct.armor.items.TravelGear;
import tconstruct.library.armor.ArmorPart;
import tconstruct.tools.TinkerTools;

public class TravelWings
extends TravelGear {
    public TravelWings() {
        super(ArmorPart.Legs);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerModifiers(IIconRegister IIconRegister2) {
        String base = "tinker:armor/travel_wings_";
        this.modifiers = new IIcon[5];
        this.modifiers[0] = IIconRegister2.registerIcon("tinker:" + this.textureFolder + "/wings_doublejump");
        this.modifiers[1] = IIconRegister2.registerIcon("tinker:" + this.textureFolder + "/wings_featherfall");
        this.modifiers[4] = IIconRegister2.registerIcon("tinker:" + this.textureFolder + "/wings_moss");
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        super.onArmorTick(world, player, itemStack);
        NBTTagCompound tag = itemStack.getTagCompound().getCompoundTag(this.getBaseTagName());
        int feather = tag.getInteger("Feather Fall");
        if (feather > 0) {
            float terminalVelocity;
            if ((double)player.fallDistance > 2.5) {
                player.fallDistance = 2.5f;
            }
            if ((terminalVelocity = -0.4f + (float)feather * 0.08f) > -0.05f) {
                terminalVelocity = -0.05f;
            }
            if (player.isSneaking() && terminalVelocity > -0.8f) {
                terminalVelocity = -0.8f;
            }
            boolean flying = false;
            flying = player.capabilities.isFlying;
            if (!flying && player.motionY < (double)terminalVelocity) {
                player.motionY = terminalVelocity;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String layer) {
        return "tinker:textures/armor/travel_wings.png";
    }

    @Override
    public ItemStack getRepairMaterial(ItemStack input) {
        return new ItemStack(TinkerTools.materials, 1, 13);
    }
}

