/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor.model;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import tconstruct.armor.items.ArmorPattern;

public class RenderArmorCast
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (helper) {
            case BLOCK_3D: {
                return true;
            }
            case ENTITY_BOBBING: {
                return true;
            }
            case ENTITY_ROTATION: {
                return true;
            }
            case EQUIPPED_BLOCK: {
                return true;
            }
            case INVENTORY_BLOCK: {
                return true;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        RenderBlocks renderer = Minecraft.getMinecraft().renderGlobal.renderBlocksRg;
        Tessellator tessellator = Tessellator.instance;
        IIcon baseIcon = item.getItem() instanceof ArmorPattern ? ((ArmorPattern)item.getItem()).getBaseIcon() : item.getIconIndex();
        GL11.glPushMatrix();
        switch (type) {
            case ENTITY: {
                GL11.glScalef((float)0.8f, (float)0.33f, (float)0.8f);
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                break;
            }
            case INVENTORY: {
                GL11.glScalef((float)1.0f, (float)0.6f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
                break;
            }
            case EQUIPPED: {
                GL11.glScalef((float)1.0f, (float)0.6f, (float)1.0f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glScalef((float)1.0f, (float)0.6f, (float)1.0f);
                break;
            }
        }
        renderer.setRenderBounds((double)0.1f, (double)0.1f, (double)0.1f, (double)0.9f, (double)0.83f, (double)0.9f);
        this.renderCube(tessellator, renderer, baseIcon);
        renderer.setRenderBounds((double)0.1f, (double)0.1f, (double)0.1f, (double)0.9f, 1.0, (double)0.9f);
        ArrayList<ForgeDirection> sides = new ArrayList<ForgeDirection>();
        sides.add(ForgeDirection.NORTH);
        sides.add(ForgeDirection.SOUTH);
        sides.add(ForgeDirection.EAST);
        sides.add(ForgeDirection.WEST);
        this.renderSelectedCube(tessellator, renderer, baseIcon, sides);
        this.renderCastTop(item, type);
        GL11.glPopMatrix();
    }

    public void renderCube(Tessellator tessellator, RenderBlocks renderer, IIcon icon) {
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderer.renderFaceXNeg((Block)null, 0.0, 0.0, 0.0, icon);
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderer.renderFaceXPos((Block)null, 0.0, 0.0, 0.0, icon);
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderer.renderFaceYNeg((Block)null, 0.0, 0.0, 0.0, icon);
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderer.renderFaceYPos((Block)null, 0.0, 0.0, 0.0, icon);
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderer.renderFaceZNeg((Block)null, 0.0, 0.0, 0.0, icon);
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderer.renderFaceZPos((Block)null, 0.0, 0.0, 0.0, icon);
        tessellator.draw();
    }

    public void renderSelectedCube(Tessellator tessellator, RenderBlocks renderer, IIcon icon, List<ForgeDirection> sidesToRender) {
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        if (sidesToRender.contains(ForgeDirection.WEST)) {
            renderer.renderFaceXNeg((Block)null, 0.0, 0.0, 0.0, icon);
        }
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        if (sidesToRender.contains(ForgeDirection.EAST)) {
            renderer.renderFaceXPos((Block)null, 0.0, 0.0, 0.0, icon);
        }
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        if (sidesToRender.contains(ForgeDirection.DOWN)) {
            renderer.renderFaceYNeg((Block)null, 0.0, 0.0, 0.0, icon);
        }
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        if (sidesToRender.contains(ForgeDirection.UP)) {
            renderer.renderFaceYPos((Block)null, 0.0, 0.0, 0.0, icon);
        }
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        if (sidesToRender.contains(ForgeDirection.SOUTH)) {
            renderer.renderFaceZNeg((Block)null, 0.0, 0.0, 0.0, icon);
        }
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        if (sidesToRender.contains(ForgeDirection.NORTH)) {
            renderer.renderFaceZPos((Block)null, 0.0, 0.0, 0.0, icon);
        }
        tessellator.draw();
    }

    public void renderCastTop(ItemStack par1ItemStack, IItemRenderer.ItemRenderType type) {
        GL11.glPushMatrix();
        IIcon icon = par1ItemStack.getIconIndex();
        if (icon == null) {
            GL11.glPopMatrix();
            return;
        }
        TextureManager texturemanager = Minecraft.getMinecraft().renderEngine;
        texturemanager.bindTexture(texturemanager.getResourceLocation(par1ItemStack.getItemSpriteNumber()));
        Tessellator tessellator = Tessellator.instance;
        float f = icon.getMinU();
        float f1 = icon.getMaxU();
        float f2 = icon.getMinV();
        float f3 = icon.getMaxV();
        float f4 = 0.0f;
        float f5 = 0.3f;
        GL11.glTranslatef((float)(-f4), (float)(-f5), (float)0.0f);
        float f6 = 1.5f;
        GL11.glRotatef((float)90.0f, (float)90.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)0.9f, (float)0.9f, (float)2.0f);
        GL11.glTranslatef((float)0.05f, (float)0.05f, (float)-0.6f);
        RenderArmorCast.renderItemIn2D(tessellator, f1, f2, f, f3, icon.getIconWidth(), icon.getIconHeight(), 0.0625f);
        GL11.glScalef((float)0.8f, (float)0.8f, (float)0.9f);
        GL11.glTranslatef((float)0.125f, (float)0.125f, (float)0.05f);
        RenderArmorCast.renderItemIn2D(tessellator, f1, f2, f, f3, icon.getIconWidth(), icon.getIconHeight(), 0.0625f);
        GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
        GL11.glTranslatef((float)0.335f, (float)0.335f, (float)0.05f);
        RenderArmorCast.renderItemIn2D(tessellator, f1, f2, f, f3, icon.getIconWidth(), icon.getIconHeight(), 0.0625f);
        GL11.glPopMatrix();
    }

    public static void renderItemIn2D(Tessellator par0Tessellator, float par1, float par2, float par3, float par4, float par5, float par6, float par7) {
        float f9;
        float f8;
        float f7;
        par0Tessellator.startDrawingQuads();
        par0Tessellator.setNormal(0.0f, 0.0f, 1.0f);
        par0Tessellator.addVertexWithUV(0.0, 0.0, 0.0, (double)par1, (double)par4);
        par0Tessellator.addVertexWithUV(1.0, 0.0, 0.0, (double)par3, (double)par4);
        par0Tessellator.addVertexWithUV(1.0, 1.0, 0.0, (double)par3, (double)par2);
        par0Tessellator.addVertexWithUV(0.0, 1.0, 0.0, (double)par1, (double)par2);
        par0Tessellator.draw();
        par0Tessellator.startDrawingQuads();
        par0Tessellator.setNormal(0.0f, 0.0f, -1.0f);
        par0Tessellator.addVertexWithUV(0.0, 1.0, (double)(0.0f - par7), (double)par1, (double)par2);
        par0Tessellator.addVertexWithUV(1.0, 1.0, (double)(0.0f - par7), (double)par3, (double)par2);
        par0Tessellator.addVertexWithUV(1.0, 0.0, (double)(0.0f - par7), (double)par3, (double)par4);
        par0Tessellator.addVertexWithUV(0.0, 0.0, (double)(0.0f - par7), (double)par1, (double)par4);
        par0Tessellator.draw();
        float f5 = 0.5f * (par1 - par3) / par5;
        float f6 = 0.5f * (par4 - par2) / par6;
        par0Tessellator.startDrawingQuads();
        par0Tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        int k = 0;
        while ((float)k < par5) {
            f7 = (float)k / par5;
            f8 = par1 + (par3 - par1) * f7 - f5;
            par0Tessellator.addVertexWithUV((double)f7, 0.0, (double)(0.0f - par7), (double)f8, (double)par4);
            par0Tessellator.addVertexWithUV((double)f7, 0.0, 0.0, (double)f8, (double)par4);
            par0Tessellator.addVertexWithUV((double)f7, 1.0, 0.0, (double)f8, (double)par2);
            par0Tessellator.addVertexWithUV((double)f7, 1.0, (double)(0.0f - par7), (double)f8, (double)par2);
            ++k;
        }
        par0Tessellator.draw();
        par0Tessellator.startDrawingQuads();
        par0Tessellator.setNormal(1.0f, 0.0f, 0.0f);
        k = 0;
        while ((float)k < par5) {
            f7 = (float)k / par5;
            f8 = par1 + (par3 - par1) * f7 - f5;
            f9 = f7 + 1.0f / par5;
            par0Tessellator.addVertexWithUV((double)f9, 1.0, (double)(0.0f - par7), (double)f8, (double)par2);
            par0Tessellator.addVertexWithUV((double)f9, 1.0, 0.0, (double)f8, (double)par2);
            par0Tessellator.addVertexWithUV((double)f9, 0.0, 0.0, (double)f8, (double)par4);
            par0Tessellator.addVertexWithUV((double)f9, 0.0, (double)(0.0f - par7), (double)f8, (double)par4);
            ++k;
        }
        par0Tessellator.draw();
        par0Tessellator.startDrawingQuads();
        par0Tessellator.setNormal(0.0f, 1.0f, 0.0f);
        k = 0;
        while ((float)k < par6) {
            f7 = (float)k / par6;
            f8 = par4 + (par2 - par4) * f7 - f6;
            f9 = f7 + 1.0f / par6;
            par0Tessellator.addVertexWithUV(0.0, (double)f9, 0.0, (double)par1, (double)f8);
            par0Tessellator.addVertexWithUV(1.0, (double)f9, 0.0, (double)par3, (double)f8);
            par0Tessellator.addVertexWithUV(1.0, (double)f9, (double)(0.0f - par7), (double)par3, (double)f8);
            par0Tessellator.addVertexWithUV(0.0, (double)f9, (double)(0.0f - par7), (double)par1, (double)f8);
            ++k;
        }
        par0Tessellator.draw();
        par0Tessellator.startDrawingQuads();
        par0Tessellator.setNormal(0.0f, -1.0f, 0.0f);
        k = 0;
        while ((float)k < par6) {
            f7 = (float)k / par6;
            f8 = par4 + (par2 - par4) * f7 - f6;
            par0Tessellator.addVertexWithUV(1.0, (double)f7, 0.0, (double)par3, (double)f8);
            par0Tessellator.addVertexWithUV(0.0, (double)f7, 0.0, (double)par1, (double)f8);
            par0Tessellator.addVertexWithUV(0.0, (double)f7, (double)(0.0f - par7), (double)par1, (double)f8);
            par0Tessellator.addVertexWithUV(1.0, (double)f7, (double)(0.0f - par7), (double)par3, (double)f8);
            ++k;
        }
        par0Tessellator.draw();
    }
}

