/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;

public class WingModel
extends ModelBiped {
    ModelRenderer WingBaseRight;
    ModelRenderer WingEdgeRight;
    ModelRenderer WingInsetRight;
    ModelRenderer WingCenterRight;
    ModelRenderer WingFlangeRight;
    ModelRenderer WingAuxRight;
    ModelRenderer WingBaseLeft;
    ModelRenderer WingEdgeLeft;
    ModelRenderer WingInsetLeft;
    ModelRenderer WingCenterLeft;
    ModelRenderer WingFlangeLeft;
    ModelRenderer WingAuxLeft;

    public WingModel() {
        super(0.25f, 0.0f, 64, 64);
        this.textureWidth = 64;
        this.textureHeight = 32;
        this.WingBaseRight = new ModelRenderer((ModelBase)this, 0, 9);
        this.WingBaseRight.addBox(-0.5f, -1.0f, 0.0f, 1, 2, 10);
        this.WingBaseRight.setRotationPoint(-1.0f, 1.0f, 0.0f);
        this.setRotation(this.WingBaseRight, 0.5235988f, -0.5235988f, 0.0f);
        this.WingEdgeRight = new ModelRenderer((ModelBase)this, 0, 21);
        this.WingEdgeRight.addBox(0.0f, 0.0f, -2.0f, 1, 9, 2);
        this.WingEdgeRight.setRotationPoint(-0.502f, -1.0f, 10.0f);
        this.setRotation(this.WingEdgeRight, 0.5235988f, 0.0f, 0.0f);
        this.WingInsetRight = new ModelRenderer((ModelBase)this, 6, 21);
        this.WingInsetRight.addBox(0.0f, 0.0f, -1.0f, 1, 9, 2);
        this.WingInsetRight.setRotationPoint(-0.504f, 0.0f, 7.8f);
        this.setRotation(this.WingInsetRight, 0.3490659f, 0.0f, 0.0f);
        this.WingCenterRight = new ModelRenderer((ModelBase)this, 12, 21);
        this.WingCenterRight.addBox(0.0f, 0.0f, -1.0f, 1, 9, 2);
        this.WingCenterRight.setRotationPoint(-0.506f, 0.3f, 6.3f);
        this.setRotation(this.WingCenterRight, 0.1745329f, 0.0f, 0.0f);
        this.WingFlangeRight = new ModelRenderer((ModelBase)this, 18, 21);
        this.WingFlangeRight.addBox(0.0f, 0.0f, -1.0f, 1, 8, 2);
        this.WingFlangeRight.setRotationPoint(-0.508f, 0.3f, 5.1f);
        this.setRotation(this.WingFlangeRight, 0.0f, 0.0f, 0.0f);
        this.WingAuxRight = new ModelRenderer((ModelBase)this, 24, 21);
        this.WingAuxRight.addBox(0.0f, 0.0f, -1.0f, 1, 7, 2);
        this.WingAuxRight.setRotationPoint(-0.51f, 0.1f, 4.0f);
        this.setRotation(this.WingAuxRight, -0.1745329f, 0.0f, 0.0f);
        this.WingBaseRight.addChild(this.WingEdgeRight);
        this.WingBaseRight.addChild(this.WingInsetRight);
        this.WingBaseRight.addChild(this.WingCenterRight);
        this.WingBaseRight.addChild(this.WingFlangeRight);
        this.WingBaseRight.addChild(this.WingAuxRight);
        this.WingBaseLeft = new ModelRenderer((ModelBase)this, 42, 9);
        this.WingBaseLeft.addBox(-0.5f, -1.0f, 0.0f, 1, 2, 10);
        this.WingBaseLeft.setRotationPoint(1.0f, 1.0f, 0.0f);
        this.setRotation(this.WingBaseLeft, 0.5235988f, 0.5235988f, 0.0f);
        this.WingEdgeLeft = new ModelRenderer((ModelBase)this, 58, 21);
        this.WingEdgeLeft.addBox(0.0f, 0.0f, -2.0f, 1, 9, 2);
        this.WingEdgeLeft.setRotationPoint(-0.502f, -1.0f, 10.0f);
        this.setRotation(this.WingEdgeLeft, 0.5235988f, 0.0f, 0.0f);
        this.WingInsetLeft = new ModelRenderer((ModelBase)this, 52, 21);
        this.WingInsetLeft.addBox(0.0f, 0.0f, -1.0f, 1, 9, 2);
        this.WingInsetLeft.setRotationPoint(-0.504f, 0.0f, 7.8f);
        this.setRotation(this.WingInsetLeft, 0.3490659f, 0.0f, 0.0f);
        this.WingCenterLeft = new ModelRenderer((ModelBase)this, 46, 21);
        this.WingCenterLeft.addBox(0.0f, 0.0f, -1.0f, 1, 9, 2);
        this.WingCenterLeft.setRotationPoint(-0.506f, 0.3f, 6.3f);
        this.setRotation(this.WingCenterLeft, 0.1745329f, 0.0f, 0.0f);
        this.WingFlangeLeft = new ModelRenderer((ModelBase)this, 40, 21);
        this.WingFlangeLeft.addBox(0.0f, 0.0f, -1.0f, 1, 8, 2);
        this.WingFlangeLeft.setRotationPoint(-0.508f, 0.3f, 5.1f);
        this.setRotation(this.WingFlangeLeft, 0.0f, 0.0f, 0.0f);
        this.WingAuxLeft = new ModelRenderer((ModelBase)this, 34, 21);
        this.WingAuxLeft.addBox(0.0f, 0.0f, -1.0f, 1, 7, 2);
        this.WingAuxLeft.setRotationPoint(-0.51f, 0.1f, 4.0f);
        this.setRotation(this.WingAuxLeft, -0.1745329f, 0.0f, 0.0f);
        this.WingBaseLeft.addChild(this.WingEdgeLeft);
        this.WingBaseLeft.addChild(this.WingInsetLeft);
        this.WingBaseLeft.addChild(this.WingCenterLeft);
        this.WingBaseLeft.addChild(this.WingFlangeLeft);
        this.WingBaseLeft.addChild(this.WingAuxLeft);
        this.bipedCloak.isHidden = true;
        this.bipedEars.isHidden = true;
        this.bipedHead.isHidden = true;
        this.bipedHeadwear.isHidden = true;
        this.bipedRightArm.isHidden = true;
        this.bipedLeftArm.isHidden = true;
        this.bipedRightLeg.isHidden = true;
        this.bipedLeftLeg.isHidden = true;
    }

    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        super.render(entity, f, f1, f2, f3, f4, f5);
        this.setRotationAngles(f, f1, f2, f3, f4, f5, entity);
        this.WingBaseRight.render(f5);
        this.WingBaseLeft.render(f5);
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }

    public void setRotationAngles(float f, float f1, float partialTick, float f3, float f4, float f5, Entity player) {
        super.setRotationAngles(f, f1, partialTick, f3, f4, f5, player);
        if (this.isRiding) {
            float slow = 17.0f;
            this.WingBaseRight.rotateAngleX = MathHelper.sin((float)(partialTick / slow)) / 10.0f + 0.9f;
            this.WingBaseRight.rotateAngleY = MathHelper.sin((float)(partialTick / slow)) / 5.0f - 0.7f;
            this.WingBaseRight.rotateAngleZ = MathHelper.sin((float)(partialTick / slow)) / 2.5f - 0.3f;
            this.WingBaseLeft.rotateAngleX = MathHelper.sin((float)(partialTick / slow)) / 10.0f + 0.9f;
            this.WingBaseLeft.rotateAngleY = -MathHelper.sin((float)(partialTick / slow)) / 5.0f + 0.7f;
            this.WingBaseLeft.rotateAngleZ = -MathHelper.sin((float)(partialTick / slow)) / 2.5f + 0.3f;
        } else if (player.isInWater()) {
            float slow = 17.0f;
            this.WingBaseRight.rotateAngleX = MathHelper.sin((float)(partialTick / slow)) / 15.0f + 0.5235988f;
            this.WingBaseRight.rotateAngleY = MathHelper.sin((float)(partialTick / slow)) / 15.0f - 0.8f;
            this.WingBaseRight.rotateAngleZ = MathHelper.sin((float)(partialTick / slow)) / 15.0f - 0.8f;
            this.WingBaseLeft.rotateAngleX = MathHelper.sin((float)(partialTick / slow)) / 15.0f + 0.5235988f;
            this.WingBaseLeft.rotateAngleY = -MathHelper.sin((float)(partialTick / slow)) / 15.0f + 0.8f;
            this.WingBaseLeft.rotateAngleZ = -MathHelper.sin((float)(partialTick / slow)) / 15.0f + 0.8f;
        } else if (player.posY - player.prevPosY < 0.0 && (double)player.fallDistance > 2.3) {
            float slow = 20.0f;
            this.WingBaseRight.rotateAngleX = MathHelper.sin((float)(partialTick / slow)) / 15.0f + 0.7f;
            this.WingBaseRight.rotateAngleY = MathHelper.sin((float)(partialTick / slow)) / 15.0f - 0.8f;
            this.WingBaseRight.rotateAngleZ = MathHelper.sin((float)(partialTick / slow)) / 15.0f - 0.3f;
            this.WingBaseLeft.rotateAngleX = MathHelper.sin((float)(partialTick / slow)) / 15.0f + 0.7f;
            this.WingBaseLeft.rotateAngleY = -MathHelper.sin((float)(partialTick / slow)) / 15.0f + 0.8f;
            this.WingBaseLeft.rotateAngleZ = -MathHelper.sin((float)(partialTick / slow)) / 15.0f + 0.3f;
        } else if (player.isSprinting() || this.onGround > 0.0f) {
            float slow = 1.73f;
            this.WingBaseRight.rotateAngleX = MathHelper.sin((float)(partialTick / slow)) / 15.0f + 0.5235988f;
            this.WingBaseRight.rotateAngleY = MathHelper.sin((float)(partialTick / slow)) / 15.0f - 0.6f;
            this.WingBaseRight.rotateAngleZ = MathHelper.sin((float)(partialTick / slow)) / 15.0f - 0.3f;
            this.WingBaseLeft.rotateAngleX = MathHelper.sin((float)(partialTick / slow)) / 15.0f + 0.5235988f;
            this.WingBaseLeft.rotateAngleY = -MathHelper.sin((float)(partialTick / slow)) / 15.0f + 0.6f;
            this.WingBaseLeft.rotateAngleZ = -MathHelper.sin((float)(partialTick / slow)) / 15.0f + 0.3f;
        } else {
            float slow = 17.0f;
            if (player.motionX != 0.0 || player.motionZ != 0.0) {
                slow = 6.0f;
            }
            this.WingBaseRight.rotateAngleX = MathHelper.sin((float)(partialTick / slow)) / 5.0f + 0.5235988f;
            this.WingBaseRight.rotateAngleY = MathHelper.sin((float)(partialTick / slow)) / 3.0f - 0.6f;
            this.WingBaseRight.rotateAngleZ = MathHelper.sin((float)(partialTick / slow)) / 1.5f - 0.3f;
            this.WingBaseLeft.rotateAngleX = MathHelper.sin((float)(partialTick / slow)) / 5.0f + 0.5235988f;
            this.WingBaseLeft.rotateAngleY = -MathHelper.sin((float)(partialTick / slow)) / 3.0f + 0.6f;
            this.WingBaseLeft.rotateAngleZ = -MathHelper.sin((float)(partialTick / slow)) / 1.5f + 0.3f;
        }
        if (this.isSneak) {
            this.WingBaseRight.rotateAngleX += 0.4f;
            this.WingBaseLeft.rotateAngleX += 0.4f;
        }
    }
}

