/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor.player;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.ref.WeakReference;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class KnapsackInventory
implements IInventory {
    public ItemStack[] inventory = new ItemStack[27];
    public WeakReference<EntityPlayer> parent;

    public void init(EntityPlayer player) {
        this.parent = new WeakReference<EntityPlayer>(player);
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory[slot];
    }

    public boolean isStackInSlot(int slot) {
        return this.inventory[slot] != null;
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean canDropInventorySlot(int slot) {
        return true;
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
    }

    public ItemStack decrStackSize(int slot, int quantity) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].stackSize <= quantity) {
                ItemStack stack = this.inventory[slot];
                this.inventory[slot] = null;
                return stack;
            }
            ItemStack split = this.inventory[slot].splitStack(quantity);
            if (this.inventory[slot].stackSize == 0) {
                this.inventory[slot] = null;
            }
            return split;
        }
        return null;
    }

    public String getInventoryName() {
        return "tconstruct.knapsack";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public void openChest() {
    }

    public void closeChest() {
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public void saveToNBT(NBTTagCompound tagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound invSlot = new NBTTagCompound();
            invSlot.setByte("Slot", (byte)i);
            this.inventory[i].writeToNBT(invSlot);
            tagList.appendTag((NBTBase)invSlot);
        }
        tagCompound.setTag("Knapsack", (NBTBase)tagList);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null || !tagCompound.hasKey("Knapsack")) {
            return;
        }
        NBTTagList tagList = tagCompound.getTagList("Knapsack", 10);
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound nbttagcompound = tagList.getCompoundTagAt(i);
            int j = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound);
            if (itemstack == null) continue;
            this.inventory[j] = itemstack;
        }
    }

    public void dropItems() {
        EntityPlayer player = (EntityPlayer)this.parent.get();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            player.func_146097_a(this.inventory[i], true, false);
            this.inventory[i] = null;
        }
    }

    public void unequipItems() {
        EntityPlayer player = (EntityPlayer)this.parent.get();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            this.dropItemEntity((Entity)player, this.inventory[i]);
            this.inventory[i] = null;
        }
    }

    void dropItemEntity(Entity dropper, ItemStack dropStack) {
        EntityItem entityitem = new EntityItem(dropper.worldObj, dropper.posX, dropper.posY, dropper.posZ, dropStack);
        dropper.worldObj.spawnEntityInWorld((Entity)entityitem);
    }

    public void markDirty() {
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public void writeInventoryToStream(ByteBuf os) throws IOException {
        for (int i = 0; i < 27; ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)os, (ItemStack)this.inventory[i]);
        }
    }

    public void readInventoryFromStream(ByteBuf is) throws IOException {
        for (int i = 0; i < 27; ++i) {
            this.inventory[i] = ByteBufUtils.readItemStack((ByteBuf)is);
        }
    }
}

