/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor.player;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import mantle.player.PlayerUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import tconstruct.TConstruct;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;

public class TPlayerHandler {
    private ConcurrentHashMap<UUID, TPlayerStats> playerStats = new ConcurrentHashMap();
    private final String serverLocation = "https://dl.dropboxusercontent.com/u/42769935/sticks.txt";
    private final int timeout = 1000;
    private HashSet<String> stickUsers = new HashSet();

    @SubscribeEvent
    public void PlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        this.onPlayerLogin(event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.onPlayerRespawn(event.player);
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && TPlayerStats.get((EntityPlayer)event.entity) == null) {
            TPlayerStats.register((EntityPlayer)event.entity);
        }
    }

    public void onPlayerLogin(EntityPlayer player) {
        TPlayerStats stats = TPlayerStats.get(player);
        stats.level = player.experienceLevel;
        stats.hunger = player.getFoodStats().getFoodLevel();
        if (!PHConstruct.enableHealthRegen) {
            player.worldObj.getGameRules().setOrCreateGameRule("naturalRegeneration", "false");
        }
        if (!stats.beginnerManual) {
            NBTTagList list;
            NBTTagCompound compound;
            ItemStack pattern;
            ItemStack diary;
            stats.beginnerManual = true;
            stats.battlesignBonus = true;
            if (PHConstruct.beginnerBook && !player.inventory.addItemStackToInventory(diary = new ItemStack(TinkerTools.manualBook))) {
                AbilityHelper.spawnItemAtPlayer(player, diary);
            }
            if (player.getDisplayName().toLowerCase().equals("fractuality")) {
                pattern = new ItemStack(TinkerTools.woodPattern, 1, 22);
                compound = new NBTTagCompound();
                compound.setTag("display", (NBTBase)new NBTTagCompound());
                compound.getCompoundTag("display").setString("Name", "\u00a7fFudgy_Fetus' Full Guard Pattern");
                list = new NBTTagList();
                list.appendTag((NBTBase)new NBTTagString("\u00a72\u00a7oThe creator and the creation"));
                list.appendTag((NBTBase)new NBTTagString("\u00a72\u00a7oare united at last!"));
                compound.getCompoundTag("display").setTag("Lore", (NBTBase)list);
                pattern.setTagCompound(compound);
                AbilityHelper.spawnItemAtPlayer(player, pattern);
            }
            if (player.getDisplayName().toLowerCase().equals("zerokyuuni")) {
                pattern = new ItemStack(Items.stick);
                compound = new NBTTagCompound();
                compound.setTag("display", (NBTBase)new NBTTagCompound());
                compound.getCompoundTag("display").setString("Name", "\u00a78Cheaty Inventory");
                list = new NBTTagList();
                list.appendTag((NBTBase)new NBTTagString("\u00a72\u00a7oNyaa~"));
                compound.getCompoundTag("display").setTag("Lore", (NBTBase)list);
                pattern.setTagCompound(compound);
                AbilityHelper.spawnItemAtPlayer(player, pattern);
            }
            if (player.getDisplayName().toLowerCase().equals("zisteau")) {
                this.spawnPigmanModifier(player);
            }
            NBTTagCompound tags = player.getEntityData();
            NBTTagCompound persistTag = tags.getCompoundTag("PlayerPersisted");
            if (this.stickUsers.contains(player.getDisplayName()) && !persistTag.hasKey("TCon-Stick")) {
                ItemStack stick = new ItemStack(Items.stick);
                persistTag.setBoolean("TCon-Stick", true);
                NBTTagCompound compound2 = new NBTTagCompound();
                compound2.setTag("display", (NBTBase)new NBTTagCompound());
                compound2.getCompoundTag("display").setString("Name", "\u00a7fStick of Patronage");
                NBTTagList list2 = new NBTTagList();
                list2.appendTag((NBTBase)new NBTTagString("Thank you for supporting"));
                list2.appendTag((NBTBase)new NBTTagString("Tinkers' Construct!"));
                compound2.getCompoundTag("display").setTag("Lore", (NBTBase)list2);
                stick.setTagCompound(compound2);
                stick.addEnchantment(Enchantment.knockback, 2);
                stick.addEnchantment(Enchantment.sharpness, 3);
                AbilityHelper.spawnItemAtPlayer(player, stick);
                tags.setTag("PlayerPersisted", (NBTBase)persistTag);
            }
        } else if (!stats.battlesignBonus) {
            stats.battlesignBonus = true;
            ItemStack modifier = new ItemStack(TinkerTools.creativeModifier);
            NBTTagCompound compound = new NBTTagCompound();
            compound.setTag("display", (NBTBase)new NBTTagCompound());
            NBTTagList list = new NBTTagList();
            list.appendTag((NBTBase)new NBTTagString("Battlesigns were buffed recently."));
            list.appendTag((NBTBase)new NBTTagString("This might make up for it."));
            compound.getCompoundTag("display").setTag("Lore", (NBTBase)list);
            compound.setString("TargetLock", TinkerTools.battlesign.getToolName());
            modifier.setTagCompound(compound);
            AbilityHelper.spawnItemAtPlayer(player, modifier);
            if (player.getDisplayName().toLowerCase().equals("zisteau")) {
                this.spawnPigmanModifier(player);
            }
        }
        if (PHConstruct.gregtech && Loader.isModLoaded((String)"GregTech-Addon")) {
            PHConstruct.gregtech = false;
            if (PHConstruct.lavaFortuneInteraction) {
                PlayerUtils.sendChatMessage((EntityPlayer)player, (String)"Warning: Cross-mod Exploit Present!");
                PlayerUtils.sendChatMessage((EntityPlayer)player, (String)"Solution 1: Disable Reverse Smelting recipes from GregTech.");
                PlayerUtils.sendChatMessage((EntityPlayer)player, (String)"Solution 2: Disable Auto-Smelt/Fortune interaction from TConstruct.");
            }
        }
    }

    void spawnPigmanModifier(EntityPlayer entityplayer) {
        ItemStack modifier = new ItemStack(TinkerTools.creativeModifier);
        NBTTagCompound compound = new NBTTagCompound();
        compound.setTag("display", (NBTBase)new NBTTagCompound());
        compound.getCompoundTag("display").setString("Name", "Zistonian Bonus Modifier");
        NBTTagList list = new NBTTagList();
        list.appendTag((NBTBase)new NBTTagString("Zombie Pigmen seem to have a natural affinty"));
        list.appendTag((NBTBase)new NBTTagString("for these types of weapons."));
        compound.getCompoundTag("display").setTag("Lore", (NBTBase)list);
        compound.setString("TargetLock", TinkerTools.battlesign.getToolName());
        modifier.setTagCompound(compound);
        AbilityHelper.spawnItemAtPlayer(entityplayer, modifier);
    }

    public void onPlayerRespawn(EntityPlayer entityplayer) {
        Side side;
        TPlayerStats playerData = this.playerStats.remove(entityplayer.getPersistentID());
        TPlayerStats stats = TPlayerStats.get(entityplayer);
        if (playerData != null) {
            stats.copyFrom(playerData, false);
            stats.level = playerData.level;
            stats.hunger = playerData.hunger;
        }
        stats.init((Entity)entityplayer, entityplayer.worldObj);
        stats.armor.recalculateHealth(entityplayer, stats);
        if (PHConstruct.keepLevels) {
            entityplayer.experienceLevel = stats.level;
        }
        if (PHConstruct.keepHunger) {
            entityplayer.getFoodStats().addStats(-1 * (20 - stats.hunger), 0.0f);
        }
        if ((side = FMLCommonHandler.instance().getEffectiveSide()) == Side.CLIENT && PHConstruct.keepHunger) {
            entityplayer.getFoodStats().setFoodLevel(stats.hunger);
        }
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent evt) {
        if (evt.entityLiving instanceof EntityPlayer) {
            evt.distance -= 1.0f;
        }
    }

    @SubscribeEvent
    public void playerDeath(LivingDeathEvent event) {
        if (!(event.entity instanceof EntityPlayer)) {
            return;
        }
        if (!event.entity.worldObj.isRemote) {
            TPlayerStats properties = (TPlayerStats)event.entity.getExtendedProperties("TConstruct");
            properties.hunger = ((EntityPlayer)event.entity).getFoodStats().getFoodLevel();
            this.playerStats.put(((EntityPlayer)event.entity).getPersistentID(), properties);
        }
    }

    @SubscribeEvent
    public void playerDrops(PlayerDropsEvent evt) {
        TPlayerStats stats = this.playerStats.get(evt.entityPlayer.getPersistentID());
        stats.level = evt.entityPlayer.experienceLevel / 2;
        int hunger = evt.entityPlayer.getFoodStats().getFoodLevel();
        stats.hunger = hunger < 6 ? 6 : evt.entityPlayer.getFoodStats().getFoodLevel();
        if (evt.entityPlayer.capturedDrops != evt.drops) {
            evt.entityPlayer.capturedDrops.clear();
        }
        evt.entityPlayer.captureDrops = true;
        stats.armor.dropItems();
        stats.knapsack.dropItems();
        evt.entityPlayer.captureDrops = false;
        if (evt.entityPlayer.capturedDrops != evt.drops) {
            evt.drops.addAll(evt.entityPlayer.capturedDrops);
        }
        this.playerStats.put(evt.entityPlayer.getPersistentID(), stats);
    }

    public void updateSize(String user, float offset) {
    }

    public static void setEntitySize(float width, float height, Entity entity) {
        float que;
        if (width != entity.width || height != entity.height) {
            entity.width = width;
            entity.height = height;
            entity.boundingBox.maxX = entity.boundingBox.minX + (double)entity.width;
            entity.boundingBox.maxZ = entity.boundingBox.minZ + (double)entity.width;
            entity.boundingBox.maxY = entity.boundingBox.minY + (double)entity.height;
        }
        entity.myEntitySize = (double)(que = width % 2.0f) < 0.375 ? Entity.EnumEntitySize.SIZE_1 : ((double)que < 0.75 ? Entity.EnumEntitySize.SIZE_2 : ((double)que < 1.0 ? Entity.EnumEntitySize.SIZE_3 : ((double)que < 1.375 ? Entity.EnumEntitySize.SIZE_4 : ((double)que < 1.75 ? Entity.EnumEntitySize.SIZE_5 : Entity.EnumEntitySize.SIZE_6))));
    }

    public void buildStickURLDatabase(String location) {
        try {
            String nick;
            URL url = new URL(location);
            URLConnection con = url.openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            InputStream io = con.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(io));
            int linetracker = 1;
            while ((nick = br.readLine()) != null) {
                if (!nick.startsWith("--")) {
                    this.stickUsers.add(nick);
                }
                ++linetracker;
            }
            br.close();
        }
        catch (Exception e) {
            TConstruct.logger.error(e.getMessage() != null ? e.getMessage() : "UNKOWN DL ERROR", (Throwable)e);
        }
    }
}

