/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mantle.blocks.abstracts.InventoryLogic;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import tconstruct.library.crafting.DryingRackRecipes;

public class DryingRackLogic
extends InventoryLogic {
    int currentTime;
    int maxTime;

    public DryingRackLogic() {
        super(1, 1);
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return null;
    }

    public String getDefaultName() {
        return "";
    }

    public void updateEntity() {
        if (!this.worldObj.isRemote && this.maxTime > 0 && this.currentTime < this.maxTime) {
            ++this.currentTime;
            if (this.currentTime >= this.maxTime) {
                this.inventory[0] = DryingRackRecipes.getDryingResult(this.inventory[0]);
                this.updateDryingTime();
            }
        }
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        super.setInventorySlotContents(slot, itemstack);
        this.updateDryingTime();
    }

    public ItemStack decrStackSize(int slot, int quantity) {
        ItemStack stack = super.decrStackSize(slot, quantity);
        this.maxTime = 0;
        this.currentTime = 0;
        return stack;
    }

    public void updateDryingTime() {
        this.currentTime = 0;
        this.maxTime = this.inventory[0] != null ? DryingRackRecipes.getDryingTime(this.inventory[0]) : 0;
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public void readFromNBT(NBTTagCompound tags) {
        this.currentTime = tags.getInteger("Time");
        this.maxTime = tags.getInteger("MaxTime");
        this.readCustomNBT(tags);
    }

    public void writeToNBT(NBTTagCompound tags) {
        tags.setInteger("Time", this.currentTime);
        tags.setInteger("MaxTime", this.maxTime);
        this.writeCustomNBT(tags);
    }

    public void readCustomNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readCustomNBT(packet.func_148857_g());
        this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB cbb = AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)(this.yCoord - 1), (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1));
        return cbb;
    }

    public String getInventoryName() {
        return null;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public void closeInventory() {
    }

    public void openInventory() {
    }
}

