/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.slime;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.library.TConstructRegistry;
import tconstruct.world.TinkerWorld;

public class SlimeLeaves
extends BlockLeaves {
    private static final String[] fastLeaves = new String[]{"slimeleaves_blue_fast"};
    private static final String[] fancyLeaves = new String[]{"slimeleaves_blue_fancy"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] fastIcons;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] fancyIcons;

    public SlimeLeaves() {
        this.setCreativeTab(TConstructRegistry.blockTab);
        this.setLightOpacity(1);
        this.setHardness(0.3f);
    }

    @SideOnly(value=Side.CLIENT)
    public int getBlockColor() {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(int par1) {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.fastIcons = new IIcon[fastLeaves.length];
        this.fancyIcons = new IIcon[fancyLeaves.length];
        for (int i = 0; i < this.fastIcons.length; ++i) {
            this.fastIcons[i] = iconRegister.registerIcon("tinker:" + fastLeaves[i]);
            this.fancyIcons[i] = iconRegister.registerIcon("tinker:" + fancyLeaves[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        int tex = meta % 1;
        this.setGraphicsLevel(Minecraft.getMinecraft().gameSettings.fancyGraphics);
        if (this.field_150121_P) {
            return this.fancyIcons[tex];
        }
        return this.fastIcons[tex];
    }

    public void getSubBlocks(Item id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < this.fastIcons.length; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public boolean isLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public Item getItemDropped(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Item.getItemFromBlock((Block)TinkerWorld.slimeSapling);
    }

    public void dropBlockAsItemWithChance(World world, int x, int y, int z, int meta, float chance, int fortune) {
        if (!world.isRemote) {
            int dropChance = 35;
            if (fortune > 0 && (dropChance -= 2 << fortune) < 15) {
                dropChance = 15;
            }
            if (world.rand.nextInt(dropChance) == 0) {
                Item k1 = this.getItemDropped(meta, world.rand, fortune);
                this.dropBlockAsItem(world, x, y, z, new ItemStack(k1, 1, this.damageDropped(meta)));
            }
            dropChance = 80;
            if (fortune > 0 && (dropChance -= 10 << fortune) < 20) {
                dropChance = 20;
            }
            if ((meta & 3) == 0 && world.rand.nextInt(dropChance) == 0) {
                this.dropBlockAsItem(world, x, y, z, new ItemStack(TinkerWorld.strangeFood, 1, 0));
            }
        }
    }

    public String[] func_150125_e() {
        return new String[]{"slime"};
    }
}

