/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.traps;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mantle.blocks.MantleBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.library.TConstructRegistry;
import tconstruct.world.model.BarricadeRender;

public class BarricadeBlock
extends MantleBlock {
    Block modelBlock;
    int modelMeta;

    public BarricadeBlock(Block model, int meta) {
        super(Material.wood);
        this.modelBlock = model;
        this.modelMeta = meta;
        this.setHardness(4.0f);
        this.setCreativeTab(TConstructRegistry.blockTab);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.modelBlock.getIcon(2, this.modelMeta);
    }

    public void registerBlockIcons(IIconRegister par1IconRegister) {
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderType() {
        return BarricadeRender.model;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int x, int y, int z) {
        return AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
    }

    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int x, int y, int z) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void harvestBlock(World world, EntityPlayer player, int x, int y, int z, int meta) {
        if (meta % 4 > 0) {
            world.setBlock(x, y, z, (Block)this, meta - 1, 3);
            this.dropBlockAsItem(world, x, y, z, new ItemStack((Block)this));
        } else {
            this.dropBlockAsItem(world, x, y, z, new ItemStack((Block)this));
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        int meta;
        ItemStack stack = player.getCurrentEquippedItem();
        if (stack != null && stack.getItem() == Item.getItemFromBlock((Block)this) && !player.isSneaking() && (meta = world.getBlockMetadata(x, y, z)) % 4 != 3) {
            world.setBlock(x, y, z, (Block)this, meta + 1, 3);
            this.onBlockPlacedBy(world, x, y, z, (EntityLivingBase)player, stack);
            this.onPostBlockPlaced(world, x, y, z, meta);
            BarricadeBlock var9 = this;
            world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), ((Block)var9).stepSound.soundName, (((Block)var9).stepSound.getVolume() + 1.0f) / 2.0f, ((Block)var9).stepSound.getPitch() * 0.8f);
            player.swingItem();
            if (!player.capabilities.isCreativeMode) {
                --stack.stackSize;
            }
            return true;
        }
        return false;
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        double distance = (double)x - explosion.explosionX + ((double)y - explosion.explosionY) + ((double)z - explosion.explosionZ);
        distance = Math.abs(distance);
        double power = (double)(explosion.explosionSize * 2.0f) / distance;
        int meta = world.getBlockMetadata(x, y, z);
        int trueMeta = meta % 4;
        if ((trueMeta = (int)((double)trueMeta - power)) < 0) {
            world.setBlock(x, y, z, Blocks.air, 0, 0);
        } else {
            world.setBlockMetadataWithNotify(x, y, z, (int)((double)meta - power), 3);
        }
        this.onBlockDestroyedByExplosion(world, x, y, z, explosion);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }
}

