/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.traps;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mantle.blocks.MantleBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.library.TConstructRegistry;
import tconstruct.world.TinkerWorld;
import tconstruct.world.model.PunjiRender;

public class Punji
extends MantleBlock {
    public Punji() {
        super(Material.plants);
        this.setBlockBounds(0.125f, 0.0f, 0.125f, 0.875f, 0.375f, 0.875f);
        this.stepSound = Block.soundTypeGrass;
        this.setCreativeTab(TConstructRegistry.blockTab);
        this.setHardness(3.0f);
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            int damage = world.getBlockMetadata(x, y, z) / 2 + 1;
            if (entity.fallDistance > 0.0f) {
                damage = (int)((double)damage + ((double)entity.fallDistance * 1.5 + 2.0));
            }
            entity.attackEntityFrom(DamageSource.cactus, (float)damage);
            ((EntityLivingBase)entity).addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, 20, 1));
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        int meta = world.getBlockMetadata(x, y, z);
        if (meta < 4 && (stack = player.getCurrentEquippedItem()) != null && stack.getItem() == Item.getItemFromBlock((Block)TinkerWorld.punji)) {
            world.setBlockMetadataWithNotify(x, y, z, meta + 1, 3);
            world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.stepSound.soundName, (this.stepSound.getVolume() + 1.0f) / 2.0f, this.stepSound.getPitch() * 0.8f);
            player.swingItem();
            if (!player.capabilities.isCreativeMode) {
                --stack.stackSize;
                if (stack.stackSize <= 0) {
                    player.destroyCurrentEquippedItem();
                }
            }
        }
        return true;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return meta + 1;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return PunjiRender.model;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockIcon = iconRegister.registerIcon("tinker:punji");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }
}

